/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.gef.annotation.AbstractGraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalMarkerAnnotation;

public abstract class ResourceMarkerGraphicalAnnotationModel
extends AbstractGraphicalAnnotationModel {
    private final IResource resource;
    private final Map<IMarker, GraphicalMarkerAnnotation> markerAnnotations = new ConcurrentHashMap<IMarker, GraphicalMarkerAnnotation>();
    private final IResourceChangeListener resourceChangeListener = this::resourceChanged;

    protected ResourceMarkerGraphicalAnnotationModel(IResource resource) {
        this.resource = Objects.requireNonNull(resource);
        resource.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    @Override
    public void refresh() {
        Set<IMarker> markers = this.findMarkers();
        HashSet added = new HashSet();
        HashSet removed = new HashSet();
        this.forEach(annotation -> {
            if (annotation.isTransient()) {
                removed.add(annotation);
            }
        });
        this.markerAnnotations.keySet().stream().filter(Predicate.not(markers::contains)).forEach((? super T marker) -> this.markerRemoved((IMarker)marker, removed));
        this.markerAnnotations.values().removeIf(Predicate.not(this::containsAnnotation));
        markers.forEach((? super T marker) -> this.markerAdded((IMarker)marker, added));
        this.updateAnnotations(added, removed, Collections.emptySet());
    }

    @Override
    public void reload() {
        Set<IMarker> markers = this.findMarkers();
        HashSet added = new HashSet();
        HashSet removed = new HashSet();
        this.forEach(removed::add);
        this.markerAnnotations.clear();
        markers.forEach((? super T marker) -> this.markerAdded((IMarker)marker, added));
        this.updateAnnotations(added, removed, Collections.emptySet());
    }

    @Override
    public void dispose() {
        this.resource.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.markerAnnotations.clear();
        super.dispose();
    }

    protected void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta child;
        IResourceDelta delta = event.getDelta();
        if (delta != null && (child = delta.findMember(this.resource.getFullPath())) != null) {
            this.markersChanged(child.getMarkerDeltas());
        }
    }

    protected void markersChanged(IMarkerDelta[] deltas) {
        if (deltas.length == 0) {
            return;
        }
        HashSet<GraphicalAnnotation> added = new HashSet<GraphicalAnnotation>();
        HashSet<GraphicalAnnotation> removed = new HashSet<GraphicalAnnotation>();
        HashSet<GraphicalAnnotation> changed = new HashSet<GraphicalAnnotation>();
        IMarkerDelta[] iMarkerDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            switch (delta.getKind()) {
                case 1: {
                    this.markerAdded(delta.getMarker(), added);
                    break;
                }
                case 2: {
                    this.markerRemoved(delta.getMarker(), removed);
                    break;
                }
                case 4: {
                    this.markerChanged(delta, added, removed, changed);
                    break;
                }
            }
            ++n2;
        }
        this.updateAnnotations(added, removed, changed);
    }

    protected void markerAdded(IMarker marker, Set<GraphicalAnnotation> added) {
        this.markerAnnotations.computeIfAbsent(marker, unused -> {
            GraphicalMarkerAnnotation annotation = this.createMarkerAnnotation(marker);
            if (annotation != null) {
                added.add(annotation);
            }
            return annotation;
        });
    }

    protected void markerRemoved(IMarker marker, Set<GraphicalAnnotation> removed) {
        this.markerAnnotations.computeIfPresent(marker, (unused, annotation) -> {
            removed.add((GraphicalAnnotation)annotation);
            return null;
        });
    }

    protected void markerChanged(IMarkerDelta delta, Set<GraphicalAnnotation> added, Set<GraphicalAnnotation> removed, Set<GraphicalAnnotation> changed) {
        this.markerAnnotations.computeIfPresent(delta.getMarker(), (marker, annotation) -> {
            if (this.isTargetChanged(delta)) {
                removed.add((GraphicalAnnotation)annotation);
                annotation = this.createMarkerAnnotation((IMarker)marker);
                if (annotation != null) {
                    added.add((GraphicalAnnotation)annotation);
                }
            } else {
                annotation.refresh();
                changed.add((GraphicalAnnotation)annotation);
            }
            return annotation;
        });
    }

    protected abstract GraphicalMarkerAnnotation createMarkerAnnotation(IMarker var1);

    protected abstract boolean isTargetChanged(IMarkerDelta var1);

    protected Set<IMarker> findMarkers() {
        try {
            return Set.of(this.resource.findMarkers("org.eclipse.core.resources.marker", true, 0));
        }
        catch (CoreException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public long getModificationStamp() {
        return this.resource.getModificationStamp();
    }

    public IResource getResource() {
        return this.resource;
    }
}

