/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.handlers;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class FontComboContributionItem
extends WorkbenchWindowControlContribution {
    private Combo combo;
    private FontRegistry fontRegistry;
    private final String[] options = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private final IPropertyChangeListener propertyChangeListener = event -> {
        if (event.getProperty().equals("org.eclipse.jface.textfont") && event.getNewValue() instanceof FontData[]) {
            this.updateComboText();
        }
    };

    public FontComboContributionItem() {
        super("org.eclipse.gef.zoom_widget");
    }

    public FontComboContributionItem(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        this.fontRegistry = this.getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        this.fontRegistry.addListener(this.propertyChangeListener);
        this.combo = new Combo(parent, 4);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FontComboContributionItem.this.handleComboSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FontComboContributionItem.this.handleComboSelected();
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                FontComboContributionItem.this.refresh();
            }
        });
        this.combo.setItems(this.options);
        this.updateComboText();
        return this.combo;
    }

    public void dispose() {
        super.dispose();
        this.fontRegistry.removeListener(this.propertyChangeListener);
        this.combo = null;
    }

    private void refresh() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        this.updateComboText();
        this.combo.pack();
        this.combo.getParent().pack();
    }

    private void handleComboSelected() {
        int selected = this.combo.getSelectionIndex();
        if (selected >= 0) {
            this.updateFontHeight(Integer.parseInt(this.combo.getItem(selected)));
        } else if (FontComboContributionItem.validParseInt(this.combo.getText())) {
            this.updateFontHeight(Integer.parseInt(this.combo.getText()));
        }
        this.updateComboText();
    }

    private static boolean validParseInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void updateComboText() {
        this.combo.setText(Integer.toString(this.fontRegistry.getFontData("org.eclipse.jface.textfont")[0].getHeight()));
    }

    private void updateFontHeight(int newHeight) {
        if (newHeight < 1 || newHeight > 256) {
            return;
        }
        FontData[] currentFontData = this.fontRegistry.getFontData("org.eclipse.jface.textfont");
        FontData[] newFontData = FontDescriptor.createFrom((FontData[])currentFontData).setHeight(newHeight).getFontData();
        if (newFontData != null) {
            this.fontRegistry.put("org.eclipse.jface.textfont", newFontData);
        }
    }
}

