/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.builder;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.Messages;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;

public class LibraryBuilder
extends IncrementalProjectBuilder {
    private static final int MASK = 7;
    private final List<String> changedLibs = new LinkedList<String>();
    private final IResourceDeltaVisitor visitor = delta -> {
        switch (delta.getResource().getType()) {
            case 1: {
                IFile file;
                IResource iResource = delta.getResource();
                if (iResource instanceof IFile && "MANIFEST.MF".equals((file = (IFile)iResource).getName()) && (file.isLinked() || delta.getKind() == 2) && (delta.getKind() & 7) != 0) {
                    this.changedLibs.add(file.getParent().getName());
                }
                return false;
            }
            case 2: {
                IResource iResource = delta.getResource();
                if (!(iResource instanceof IFolder)) break;
                IFolder folder = (IFolder)iResource;
                return LibraryBuilder.isLinkedLibraryFolder((IContainer)folder) || (folder.isLinked() || delta.getKind() == 2) && LibraryBuilder.isLinkedLibraryFolder(folder.getParent());
            }
        }
        return true;
    };

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LibraryBuilder_ResolveProjectDependencies, (int)1);
        IProject project = this.getProject();
        Manifest manifest = ManifestHelper.getContainerManifest((IContainer)project);
        if (manifest != null) {
            if (kind == 6) {
                LibraryBuilder.fullBuild(project, manifest, (IProgressMonitor)progress.split(1));
            } else {
                boolean projectManifestChanged = false;
                this.changedLibs.clear();
                IResourceDelta delta = this.getDelta(project);
                IResourceDelta md = delta.findMember((IPath)new Path("MANIFEST.MF"));
                if (md != null && (md.getKind() & 5) != 0) {
                    projectManifestChanged = true;
                }
                delta.accept(this.visitor, 8);
                if (projectManifestChanged || !this.changedLibs.isEmpty()) {
                    LibraryBuilder.fullBuild(project, manifest, (IProgressMonitor)progress.split(1));
                }
            }
        }
        return new IProject[0];
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LibraryBuilder_CleaningLibrary, (int)1);
        FordiacMarkerHelper.updateMarkers((IResource)this.getProject().getFile("MANIFEST.MF"), (String)"org.eclipse.fordiac.ide.model.library", Collections.emptyList(), (boolean)true);
        progress.worked(1);
        SubMonitor.done((IProgressMonitor)monitor);
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return this.getProject();
    }

    private static void fullBuild(IProject project, Manifest manifest, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LibraryBuilder_LibraryBuild, (int)1);
        LibraryManager.INSTANCE.resolveDependencies(project, manifest, (IProgressMonitor)progress.split(1));
    }

    private static boolean isLinkedLibraryFolder(IContainer container) {
        return container instanceof IFolder && container.getParent() instanceof IProject && ("Standard Libraries".equals(container.getName()) || "External Libraries".equals(container.getName()));
    }
}

