/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.errormarker;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;

public final class ErrorMarkerBuilder {
    private String type = "org.eclipse.fordiac.ide.model.iec61499";
    private int severity = 2;
    private int priority = 2;
    private int lineNumber = -1;
    private String message;
    private String location;
    private int code;
    private String source;
    private EObject target;
    private EStructuralFeature feature;
    private Map<String, Object> additionalAttributes;

    protected ErrorMarkerBuilder() {
    }

    protected ErrorMarkerBuilder(String message) {
        this.message = message;
    }

    public static ErrorMarkerBuilder createErrorMarkerBuilder(String message) {
        return new ErrorMarkerBuilder(message);
    }

    public IMarker createMarker(IResource resource) throws CoreException {
        return resource.createMarker(this.type, this.getAttributes(resource));
    }

    public Map<String, Object> getAttributes() {
        return this.getAttributes(null);
    }

    public Map<String, Object> getAttributes(IResource resource) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("severity", this.severity);
        attributes.put("priority", this.priority);
        if (this.lineNumber >= 0) {
            attributes.put("lineNumber", this.lineNumber);
        }
        if (this.message != null) {
            attributes.put("message", this.message);
        }
        if (this.location != null) {
            attributes.put("location", this.location);
        } else if (this.target != null) {
            attributes.put("location", FordiacMarkerHelper.getLocation(this.target, this.feature));
        }
        if (this.code != 0) {
            attributes.put("org.eclipse.fordiac.ide.model.iec61499.code", this.code);
        }
        if (this.source != null) {
            attributes.put("org.eclipse.fordiac.ide.model.iec61499.source", this.source);
        }
        if (this.target != null) {
            attributes.put("org.eclipse.fordiac.ide.model.iec61499.targetUri", FordiacMarkerHelper.getTargetUri(resource, this.target).toString());
            attributes.put("org.eclipse.fordiac.ide.model.iec61499.targetType", EcoreUtil.getURI((EObject)this.target.eClass()).toString());
        }
        if (this.feature != null) {
            attributes.put("org.eclipse.fordiac.ide.model.iec61499.targetFeature", EcoreUtil.getURI((EObject)this.feature).toString());
        }
        if (this.additionalAttributes != null) {
            attributes.putAll(this.additionalAttributes);
        }
        return attributes;
    }

    public String getType() {
        return this.type;
    }

    public ErrorMarkerBuilder setType(String type) {
        this.type = type != null ? type : "org.eclipse.fordiac.ide.model.iec61499";
        return this;
    }

    public int getSeverity() {
        return this.severity;
    }

    public ErrorMarkerBuilder setSeverity(int severity) {
        this.severity = severity;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public ErrorMarkerBuilder setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public ErrorMarkerBuilder setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorMarkerBuilder setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public ErrorMarkerBuilder setLocation(String location) {
        this.location = location;
        return this;
    }

    public EObject getTarget() {
        return this.target;
    }

    public int getCode() {
        return this.code;
    }

    public ErrorMarkerBuilder setCode(int code) {
        this.code = code;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public ErrorMarkerBuilder setSource(String source) {
        this.source = source;
        return this;
    }

    public ErrorMarkerBuilder setTarget(EObject target) {
        this.target = target;
        return this;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public ErrorMarkerBuilder setFeature(EStructuralFeature feature) {
        this.feature = feature;
        return this;
    }

    public ErrorMarkerBuilder addAdditionalAttributes(Map<String, Object> attributes) {
        if (this.additionalAttributes == null) {
            this.additionalAttributes = new HashMap<String, Object>();
        }
        this.additionalAttributes.putAll(attributes);
        return this;
    }

    public Map<String, Object> getAdditionalAttributes() {
        if (this.additionalAttributes == null) {
            this.additionalAttributes = new HashMap<String, Object>();
        }
        return this.additionalAttributes;
    }

    public String toString() {
        return String.format("ErrorMarkerBuilder [type=%s, message=%s, location=%s, severity=%s, priority=%s, lineNumber=%s, target=%s]", this.type, this.message, this.location, this.severity, this.priority, this.lineNumber, EcoreUtil.getURI((EObject)this.target));
    }
}

