/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.util;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.fordiac.ide.model.emf.HashMetaData;
import org.eclipse.fordiac.ide.model.util.LibraryElementHashException;

public final class LibraryElementHasher {
    public static final String CURRENT_HASH_VERSION = "v1";
    public static final String DEFAULT_HASH_ALGORITHM = "SHA3-512";
    private static final String XMI_EXTENSION = "xmi";
    private static final String TOHASH_XMI_URI = "tohash.xmi";

    public static String hash(EObject eObject) throws LibraryElementHashException {
        return LibraryElementHasher.hash(eObject, CURRENT_HASH_VERSION, DEFAULT_HASH_ALGORITHM);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String hash(EObject eObject, String version, String algorithm) throws LibraryElementHashException {
        if (!CURRENT_HASH_VERSION.equals(version)) {
            throw new LibraryElementHashException(MessageFormat.format("Wrong library hash version: {0}", version));
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LibraryElementHashException("could not aquire hashing algorithm", e);
        }
        ResourceSetImpl xmiResourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().putIfAbsent(XMI_EXTENSION, new XMIResourceFactoryImpl());
        Resource xmiResource = xmiResourceSet.createResource(URI.createFileURI((String)TOHASH_XMI_URI));
        xmiResource.getContents().add((Object)LibraryElementHasher.copyForHashing(eObject));
        StringBuilder sb = new StringBuilder(version);
        sb.append(':');
        sb.append(algorithm);
        sb.append(':');
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try {
                OutputStream nullOut = OutputStream.nullOutputStream();
                try {
                    try (DigestOutputStream dos = new DigestOutputStream(nullOut, digest);){
                        HashMap<String, Object> options = new HashMap<String, Object>();
                        options.put("PROCESS_DANGLING_HREF", "DISCARD");
                        options.put("SKIP_ESCAPE_URI", Boolean.FALSE);
                        xmiResource.save((OutputStream)dos, options);
                        sb.append(Base64.getUrlEncoder().encodeToString(digest.digest()));
                    }
                    if (nullOut == null) return sb.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (nullOut == null) throw throwable;
                    nullOut.close();
                    throw throwable;
                }
                nullOut.close();
                return sb.toString();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LibraryElementHashException("Problem with generating library element hash", e);
        }
    }

    private static EObject copyForHashing(EObject eObject) {
        HashCopier copier = new HashCopier();
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        return result;
    }

    private LibraryElementHasher() {
        throw new UnsupportedOperationException("Utility class shall not be instantiated");
    }

    private static class HashCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;

        private HashCopier() {
        }

        public EObject copy(EObject eObject) {
            if (eObject == null) {
                return null;
            }
            if (!HashMetaData.isIgnored((EModelElement)eObject.eClass())) {
                return super.copy(eObject);
            }
            return null;
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (!HashMetaData.isIgnored((EModelElement)eAttribute)) {
                super.copyAttribute(eAttribute, eObject, copyEObject);
            }
        }

        protected void copyAttributeValue(EAttribute eAttribute, EObject eObject, Object value, EStructuralFeature.Setting setting) {
            super.copyAttributeValue(eAttribute, eObject, HashMetaData.transform((EModelElement)eAttribute, value), setting);
        }
    }
}

