/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class TimeValueConverter
implements ValueConverter<Duration> {
    public static final TimeValueConverter INSTANCE = new TimeValueConverter();
    static final Pattern VALUE_PATTERN = Pattern.compile("([+-]?\\d++(?:\\.\\d++)?)\\s*([a-zA-Z]++)");
    static final Pattern SCANNER_PATTERN = Pattern.compile("\\G[+-]?(?:\\d[_\\d]*+(?:\\.\\d[_\\d]*+)?\\s*\\w++)++");

    private TimeValueConverter() {
    }

    @Override
    public String toString(Duration value) {
        if (value.isZero()) {
            return "0s";
        }
        long days = value.toDays();
        int hours = value.toHoursPart();
        int minutes = value.toMinutesPart();
        int seconds = value.toSecondsPart();
        int millis = value.toNanosPart() / 1000000;
        int micros = value.toNanosPart() / 1000 % 1000;
        int nanos = value.toNanosPart() % 1000;
        StringBuilder builder = new StringBuilder();
        if (days != 0L) {
            builder.append(days).append('d');
        }
        if (hours != 0) {
            builder.append(hours).append('h');
        }
        if (minutes != 0) {
            builder.append(minutes).append('m');
        }
        if (seconds != 0) {
            builder.append(seconds).append('s');
        }
        if (millis != 0) {
            builder.append(millis).append("ms");
        }
        if (micros != 0) {
            builder.append(micros).append("us");
        }
        if (nanos != 0) {
            builder.append(nanos).append("ns");
        }
        return builder.toString();
    }

    @Override
    public Duration toValue(String string) throws IllegalArgumentException {
        try {
            Matcher matcher = VALUE_PATTERN.matcher(string.replace("_", ""));
            return matcher.results().map(result -> {
                String valueGroup = result.group(1);
                String unitGroup = result.group(2);
                BigDecimal value = new BigDecimal(valueGroup);
                ChronoUnit unit = TimeValueConverter.parseUnit(unitGroup);
                return Duration.of(value.multiply(BigDecimal.valueOf(unit.getDuration().toNanos())).toBigIntegerExact().longValueExact(), ChronoUnit.NANOS);
            }).reduce(Duration.ZERO, Duration::plus);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_INVALID_TIME_LITERAL, string), e);
        }
    }

    private static ChronoUnit parseUnit(String string) {
        return switch (string.toUpperCase()) {
            case "D" -> ChronoUnit.DAYS;
            case "H" -> ChronoUnit.HOURS;
            case "M" -> ChronoUnit.MINUTES;
            case "S" -> ChronoUnit.SECONDS;
            case "MS" -> ChronoUnit.MILLIS;
            case "US" -> ChronoUnit.MICROS;
            case "NS" -> ChronoUnit.NANOS;
            default -> throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_InvalidTimeUnit, string));
        };
    }

    @Override
    public Duration toValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        return (Duration)this.toValue(scanner, SCANNER_PATTERN);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

