/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.AddNewDependenciesOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;

public class AddNewDependenciesAction
extends Action {
    private IProject fProject;
    private IBundlePluginModelBase fBase;

    public AddNewDependenciesAction(IProject project, IBundlePluginModelBase base) {
        this.fProject = project;
        this.fBase = base;
    }

    public void run() {
        WorkspaceJob job = new WorkspaceJob(PDEUIMessages.DependencyManagementSection_jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    try {
                        AddNewDependenciesOperation op = AddNewDependenciesAction.this.getOperation();
                        op.run(monitor);
                        if (!op.foundNewDependencies()) {
                            Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.AddNewDependenciesAction_title, (String)PDEUIMessages.AddNewDependenciesAction_notFound));
                        }
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_PSEARCH_OBJ);
        job.schedule();
    }

    protected AddNewDependenciesOperation getOperation() {
        return new AddDependenciesOperation(this.fProject, this.fBase);
    }

    protected class AddDependenciesOperation
    extends AddNewDependenciesOperation {
        public AddDependenciesOperation(IProject project, IBundlePluginModelBase base) {
            super(project, base);
        }

        @Override
        protected void handleNewDependencies(Map<ExportPackageDescription, String> additionalDeps, boolean useRequireBundle, IProgressMonitor monitor) {
            if (!additionalDeps.isEmpty()) {
                Display.getDefault().asyncExec(() -> this.addDependencies(additionalDeps, useRequireBundle));
            }
            monitor.done();
        }
    }
}

