/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XSDForm implements Enumerator
{
    QUALIFIED_LITERAL(0, "qualified", "qualified"),
    UNQUALIFIED_LITERAL(1, "unqualified", "unqualified");

    public static final int QUALIFIED = 0;
    public static final int UNQUALIFIED = 1;
    private static final XSDForm[] VALUES_ARRAY;
    public static final List<XSDForm> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDForm[]{QUALIFIED_LITERAL, UNQUALIFIED_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDForm get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDForm result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDForm getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDForm result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDForm get(int value) {
        switch (value) {
            case 0: {
                return QUALIFIED_LITERAL;
            }
            case 1: {
                return UNQUALIFIED_LITERAL;
            }
        }
        return null;
    }

    private XSDForm(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

