/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client.v2;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.cft.server.core.internal.client.BehaviourRequest;
import org.eclipse.cft.server.core.internal.client.ClientRequestFactory;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.StagingAwareRequest;
import org.eclipse.cft.server.core.internal.client.v2.ExternalClientV1;
import org.eclipse.cft.server.core.internal.ssh.SshClientSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class DiegoRequestFactory
extends ClientRequestFactory {
    public DiegoRequestFactory(CloudFoundryServerBehaviour behaviour) {
        super(behaviour);
    }

    @Override
    public BaseClientRequest<ApplicationStats> getApplicationStats(final String applicationId) throws CoreException {
        return new StagingAwareRequest<ApplicationStats>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_APP_STATS, (Object)applicationId), this.behaviour){

            @Override
            protected ApplicationStats doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    return client.getApplicationStats(applicationId);
                }
                catch (Exception ce) {
                    if (CloudErrorUtil.is503Error(ce) || CloudErrorUtil.isAppStoppedStateError(ce) || CloudErrorUtil.getBadRequestException(ce) != null) {
                        return null;
                    }
                    throw ce;
                }
            }
        };
    }

    @Override
    public BaseClientRequest<CloudApplication> getCloudApplication(final String appName) throws CoreException {
        return new BehaviourRequest<CloudApplication>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_GET_APPLICATION, (Object)appName), this.behaviour){

            @Override
            protected CloudApplication doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    return client.getApplication(appName);
                }
                catch (Exception e) {
                    if (CloudErrorUtil.is503Error(e)) {
                        return DiegoRequestFactory.this.getExternalClient(client).getApplicationNoRunningInstances(appName);
                    }
                    throw e;
                }
            }
        };
    }

    @Override
    public BaseClientRequest<List<CloudApplication>> getApplications() throws CoreException {
        String serverId = this.behaviour.getCloudFoundryServer().getServer().getId();
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_GET_ALL_APPS, (Object)serverId);
        return new BehaviourRequest<List<CloudApplication>>(label, this.behaviour){

            @Override
            protected List<CloudApplication> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    return client.getApplications();
                }
                catch (Exception e) {
                    if (CloudErrorUtil.is503Error(e)) {
                        return DiegoRequestFactory.this.getExternalClient(client).getApplicationsNoRunningInstances();
                    }
                    throw e;
                }
            }
        };
    }

    @Override
    public BaseClientRequest<?> stopApplication(String message, final CloudFoundryApplicationModule cloudModule) {
        return new BehaviourRequest<Void>(message, this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    client.stopApplication(cloudModule.getDeployedApplicationName());
                }
                catch (Exception e) {
                    if (CloudErrorUtil.is503Error(e)) {
                        DiegoRequestFactory.this.getExternalClient(client).stopApplication(cloudModule.getDeployedApplicationName());
                    }
                    throw e;
                }
                return null;
            }
        };
    }

    @Override
    public BaseClientRequest<String> getFile(final CloudApplication app, final int instanceIndex, final String path, final boolean isDir) throws CoreException {
        final CloudFoundryServer cloudServer = this.behaviour.getCloudFoundryServer();
        if (!cloudServer.supportsSsh()) {
            return super.getFile(app, instanceIndex, path, isDir);
        }
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_FETCHING_FILE, (Object)path, (Object)app.getName());
        return new BehaviourRequest<String>(label, this.behaviour){

            @Override
            protected String doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                if (path == null) {
                    return null;
                }
                String url = cloudServer.getUrl();
                String userName = cloudServer.getUsername();
                String password = cloudServer.getPassword();
                boolean selfSigned = cloudServer.getSelfSignedCertificate();
                SshClientSupport ssh = SshClientSupport.create(CloudFoundryServerBehaviour.createExternalClientLogin(url, userName, password, selfSigned, (IProgressMonitor)progress), new CloudCredentials(userName, password), null, selfSigned);
                Session session = ssh.connect(app, cloudServer, instanceIndex);
                String command = isDir ? "ls -p " + path : "cat " + path;
                try {
                    Channel channel = session.openChannel("exec");
                    ((ChannelExec)channel).setCommand(command);
                    String string = DiegoRequestFactory.this.getContent(channel);
                    return string;
                }
                catch (JSchException e) {
                    throw CloudErrorUtil.toCoreException(e);
                }
                finally {
                    session.disconnect();
                }
            }
        };
    }

    protected String getContent(Channel channel) throws CoreException {
        InputStream in = null;
        OutputStream outStream = null;
        try {
            in = channel.getInputStream();
            channel.connect();
            if (in != null) {
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                outStream = new BufferedOutputStream(byteArrayOut);
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = in.read(buffer)) != -1) {
                    outStream.write(buffer, 0, bytesRead);
                }
                outStream.flush();
                byteArrayOut.flush();
                String string = byteArrayOut.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw CloudErrorUtil.toCoreException(e);
        }
        catch (JSchException e) {
            throw CloudErrorUtil.toCoreException(e);
        }
        finally {
            channel.disconnect();
            try {
                if (in != null) {
                    in.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        return null;
    }

    public ExternalClientV1 getExternalClient(CloudFoundryOperations client) throws CoreException {
        CloudFoundryServer server = this.behaviour.getCloudFoundryServer();
        HttpProxyConfiguration httpProxyConfiguration = null;
        CloudSpace sessionSpace = null;
        if (server.getCloudFoundrySpace() != null && (sessionSpace = server.getCloudFoundrySpace().getSpace()) == null && server.getCloudFoundrySpace().getSpaceName() != null) {
            sessionSpace = client.getSpace(server.getCloudFoundrySpace().getSpaceName());
        }
        if (sessionSpace == null) {
            throw CloudErrorUtil.toCoreException("No Cloud space resolved for " + server.getServer().getId() + ". Please verify that the server is connected and refreshed and try again.");
        }
        return new ExternalClientV1(client, sessionSpace, server.getCloudInfo(), server.getSelfSignedCertificate(), httpProxyConfiguration);
    }
}

