/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.plugin.AbstractPluginElementDetails;
import org.eclipse.pde.internal.ui.editor.text.IControlHoverContentProvider;
import org.eclipse.pde.internal.ui.editor.text.PDETextHover;
import org.eclipse.pde.internal.ui.editor.text.TranslationHyperlink;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class ExtensionElementBodyTextDetails
extends AbstractPluginElementDetails
implements IControlHoverContentProvider {
    private IPluginElement fPluginElement = null;
    private ISchemaElement fSchemaElement = null;
    private FormEntry fTextBody = null;
    private Section fSectionElementDetails = null;
    private FormToolkit fToolkit;
    private Hyperlink fHyperlinkBody;
    private IInformationControl fInfoControlHover;

    public ExtensionElementBodyTextDetails(PDESection masterSection) {
        super(masterSection);
    }

    public void createContents(Composite parent) {
        this.createUIToolkit();
        this.configureParentLayout(parent);
        this.createUI(parent);
        this.createListeners();
    }

    private void createListeners() {
        this.createListenersTextBody();
        this.createListenersHyperlinkBody();
        this.createListenersModel();
    }

    private void createListenersHyperlinkBody() {
        this.fHyperlinkBody.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExtensionElementBodyTextDetails.this.handleHyperlinkBodyLinkActivated();
            }
        });
        PDETextHover.addHoverListenerToControl(this.fInfoControlHover, (Control)this.fHyperlinkBody, this);
    }

    private void handleHyperlinkBodyLinkActivated() {
        boolean opened = false;
        if (!this.isReferenceModel()) {
            opened = this.openReference();
        }
        if (!opened) {
            Display.getCurrent().beep();
        }
    }

    private boolean openReference() {
        if (this.fPluginElement == null) {
            return false;
        }
        TranslationHyperlink link = new TranslationHyperlink(null, this.fTextBody.getValue(), (IModel)this.fPluginElement.getModel());
        link.open();
        return link.getOpened();
    }

    private void createListenersModel() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    private void createListenersTextBody() {
        this.fTextBody.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry entry) {
                ExtensionElementBodyTextDetails.this.handleTextBodyValueChanged();
            }
        });
        PDETextHover.addHoverListenerToControl(this.fInfoControlHover, (Control)this.fTextBody.getText(), this);
    }

    private void handleTextBodyValueChanged() {
        if (this.fPluginElement == null) {
            return;
        }
        try {
            this.fPluginElement.setText(this.fTextBody.getValue());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void configureParentLayout(Composite parent) {
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
    }

    private void createUIToolkit() {
        this.fToolkit = this.getManagedForm().getToolkit();
    }

    private void createUI(Composite parent) {
        this.createUISectionElementDetails(parent);
        Composite client = this.createUISectionContainer(this.fSectionElementDetails);
        this.createUIInfoHoverControl(client);
        this.createUIHyperlinkBody(client);
        this.createUITextBody(client);
        this.fToolkit.paintBordersFor(client);
        this.fSectionElementDetails.setClient((Control)client);
        this.markDetailsPart((Control)this.fSectionElementDetails);
    }

    private void createUIInfoHoverControl(Composite client) {
        this.fInfoControlHover = PDETextHover.getInformationControlCreator().createInformationControl(client.getShell());
        this.fInfoControlHover.setSizeConstraints(300, 600);
    }

    private void createUIHyperlinkBody(Composite client) {
        this.fHyperlinkBody = this.fToolkit.createHyperlink(client, PDEUIMessages.ExtensionElementBodyTextDetails_labelBodyText, 0);
    }

    private boolean isReferenceModel() {
        return this.fPluginElement == null || this.fPluginElement.getModel().getUnderlyingResource() == null;
    }

    private Composite createUISectionContainer(Section section) {
        Composite client = this.fToolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        return client;
    }

    private void createUISectionElementDetails(Composite parent) {
        int section_style = 384;
        this.fSectionElementDetails = this.fToolkit.createSection(parent, section_style);
        this.fSectionElementDetails.clientVerticalSpacing = 6;
        this.fSectionElementDetails.setText(PDEUIMessages.ExtensionElementDetails_title);
        String description = PDEUIMessages.ExtensionElementBodyTextDetails_sectionDescElementGeneral;
        if (this.fSchemaElement != null && this.fSchemaElement.isDeprecated()) {
            description = String.valueOf(description) + "\n\n";
            description = String.valueOf(description) + NLS.bind((String)PDEUIMessages.ElementIsDeprecated, (Object)this.fSchemaElement.getName());
        }
        this.fSectionElementDetails.setDescription(description);
        this.fSectionElementDetails.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        int layout_style = 768;
        GridData data = new GridData(layout_style);
        this.fSectionElementDetails.setLayoutData((Object)data);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fSectionElementDetails);
    }

    private void createUITextBody(Composite parent) {
        int widget_style = 578;
        this.fTextBody = new FormEntry(parent, this.fToolkit, null, widget_style);
        int layout_text_style = 768;
        GridData data = new GridData(layout_text_style);
        data.heightHint = 90;
        this.fTextBody.getText().setLayoutData((Object)data);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection structured_selection = (IStructuredSelection)selection;
        this.fPluginElement = structured_selection.size() == 1 ? (IPluginElement)structured_selection.getFirstElement() : null;
        this.updateUI();
    }

    private void updateUI() {
        this.updateUISectionElementDetails();
        this.updateUITextBody();
    }

    private void updateUISectionElementDetails() {
        String description = this.fPluginElement == null ? PDEUIMessages.ExtensionElementBodyTextDetails_sectionDescElementGeneral : NLS.bind((String)PDEUIMessages.ExtensionElementBodyTextDetails_sectionDescElementSpecific, (Object)this.fPluginElement.getName());
        if (this.fSchemaElement != null && this.fSchemaElement.isDeprecated()) {
            description = String.valueOf(description) + "\n\n";
            description = String.valueOf(description) + NLS.bind((String)PDEUIMessages.ElementIsDeprecated, (Object)this.fSchemaElement.getName());
        }
        this.fSectionElementDetails.setDescription(description);
        this.fSectionElementDetails.layout();
    }

    private void updateUITextBody() {
        if (this.fPluginElement == null) {
            this.fTextBody.setEditable(false);
            this.fTextBody.setValue(null, true);
        } else {
            this.fTextBody.setEditable(this.isEditable());
            this.fTextBody.setValue(this.fPluginElement.getText(), true);
        }
    }

    @Override
    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    @Override
    public String getContextId() {
        return "plugin-context";
    }

    @Override
    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    @Override
    public boolean isEditable() {
        IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
        return model != null && model.isEditable();
    }

    public void modelChanged(IModelChangedEvent event) {
        Object object;
        if (event.getChangeType() == 3 && (object = event.getChangedObjects()[0]).equals(this.fPluginElement)) {
            this.refresh();
        }
    }

    public void refresh() {
        this.updateUI();
        super.refresh();
    }

    @Override
    public void cancelEdit() {
        this.fTextBody.cancelEdit();
        super.cancelEdit();
    }

    public void commit(boolean onSave) {
        this.fTextBody.commit();
        super.commit(onSave);
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void setFocus() {
        this.fTextBody.getText().setFocus();
    }

    @Override
    public String getHoverContent(Control control) {
        if (control instanceof Hyperlink || control instanceof Label) {
            return this.getHyperlinkDescription();
        }
        if (control instanceof Text) {
            return this.getTextDescription((Text)control);
        }
        return null;
    }

    private String getHyperlinkDescription() {
        if (this.fSchemaElement == null) {
            return null;
        }
        return this.fSchemaElement.getDescription();
    }

    private String getTextDescription(Text text) {
        if (this.fSchemaElement == null) {
            return null;
        }
        String bodyText = text.getText();
        String translatedBodyText = null;
        if (bodyText.startsWith("%") && this.fSchemaElement.hasTranslatableContent() && !bodyText.equals(translatedBodyText = this.fPluginElement.getResourceString(bodyText))) {
            return translatedBodyText;
        }
        return null;
    }

    public void setSchemaElement(ISchemaElement schemaElement) {
        this.fSchemaElement = schemaElement;
    }
}

