/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.types.PrimitiveType;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.reflect.Modifier;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.PlainAbstractClass;

public final class PlainClassMembers
extends PlainAbstractClass {
    public static final String publicStaticFinalField = "";
    public static String publicStaticField;
    public final String publicFinalField = "";
    public String publicField;
    protected static final String protectedStaticFinalField = "";
    protected static String protectedStaticField;
    protected final String protectedFinalField = "";
    protected String protectedField;
    static final String packagePrivateStaticFinalField = "";
    static String packagePrivateStaticField;
    final String packagePrivateFinalField = "";
    String packagePrivateField;
    private static final String privateStaticFinalField = "";
    private static String privateStaticField;
    private final String privateFinalField = "";
    private String privateField;

    public static final void publicStaticFinalMethod() {
    }

    public static void publicStaticMethod() {
    }

    public final void publicFinalMethod() {
    }

    public void publicMethod() {
    }

    protected static final void protectedStaticFinalMethod() {
    }

    protected static void protectedStaticMethod() {
    }

    protected final void protectedFinalMethod() {
    }

    protected void protectedMethod() {
    }

    static final void packagePrivateStaticFinalMethod() {
    }

    static void packagePrivateStaticMethod() {
    }

    final void packagePrivateFinalMethod() {
    }

    void packagePrivateMethod() {
    }

    private static final void privateStaticFinalMethod() {
    }

    private static void privateStaticMethod() {
    }

    private final void privateFinalMethod() {
    }

    private void privateMethod() {
    }

    public PlainClassMembers(boolean disambiguate) {
        super(false);
    }

    protected PlainClassMembers(int disambiguate) {
        super(false);
    }

    PlainClassMembers(double disambiguate) {
        super(false);
    }

    private PlainClassMembers(char disambiguate) {
        super(false);
    }

    @Override
    public void abstractMethod() {
    }

    public static class Verifier {
        public static void verify(ClassInfo clazz) {
            ClassInfo superClass = clazz.superClassDeclaration();
            assert (superClass.isPlainClass());
            assert (superClass.isAbstract());
            assert (!superClass.isFinal());
            assert (superClass.methods().size() == 1);
            Verifier.assertMethod(superClass, "abstractMethod", 0, false, false, true);
            assert (clazz.name().equals("org.jboss.cdi.lang.model.tck.PlainClassMembers"));
            assert (clazz.simpleName().equals("PlainClassMembers"));
            assert (clazz.isPlainClass());
            assert (!clazz.isInterface());
            assert (!clazz.isEnum());
            assert (!clazz.isAnnotation());
            assert (!clazz.isRecord());
            assert (!clazz.isAbstract());
            assert (clazz.isFinal());
            assert (Modifier.isPublic(clazz.modifiers()));
            assert (!Modifier.isProtected(clazz.modifiers()));
            assert (!Modifier.isPrivate(clazz.modifiers()));
            Verifier.verifyFields(clazz);
            Verifier.verifyMethods(clazz);
            Verifier.verifyConstructors(clazz);
        }

        private static void verifyFields(ClassInfo clazz) {
            assert (clazz.fields().size() == 16);
            Verifier.assertField(clazz, "publicStaticFinalField", 1, true, true, true);
            Verifier.assertField(clazz, "publicStaticField", 1, true, false, true);
            Verifier.assertField(clazz, "publicFinalField", 1, false, true, true);
            Verifier.assertField(clazz, "publicField", 1, false, false, true);
            Verifier.assertField(clazz, "protectedStaticFinalField", 4, true, true, true);
            Verifier.assertField(clazz, "protectedStaticField", 4, true, false, true);
            Verifier.assertField(clazz, "protectedFinalField", 4, false, true, true);
            Verifier.assertField(clazz, "protectedField", 4, false, false, true);
            Verifier.assertField(clazz, "packagePrivateStaticFinalField", 0, true, true, true);
            Verifier.assertField(clazz, "packagePrivateStaticField", 0, true, false, true);
            Verifier.assertField(clazz, "packagePrivateFinalField", 0, false, true, true);
            Verifier.assertField(clazz, "packagePrivateField", 0, false, false, true);
            Verifier.assertField(clazz, "privateStaticFinalField", 2, true, true, true);
            Verifier.assertField(clazz, "privateStaticField", 2, true, false, true);
            Verifier.assertField(clazz, "privateFinalField", 2, false, true, true);
            Verifier.assertField(clazz, "privateField", 2, false, false, true);
        }

        static void assertField(ClassInfo clazz, String name, int accesibility, boolean isStatic, boolean isFinal, boolean testStringType) {
            FieldInfo field = LangModelUtils.singleField(clazz, name);
            assert (field.declaringClass().equals(clazz));
            assert (Modifier.isPublic(field.modifiers()) == Modifier.isPublic(accesibility));
            assert (Modifier.isProtected(field.modifiers()) == Modifier.isProtected(accesibility));
            assert (Modifier.isPrivate(field.modifiers()) == Modifier.isPrivate(accesibility));
            assert (field.isFinal() == isFinal);
            assert (Modifier.isFinal(field.modifiers()) == isFinal);
            assert (field.isStatic() == isStatic);
            assert (Modifier.isStatic(field.modifiers()) == isStatic);
            Verifier.assertType(field.type(), Type.Kind.CLASS);
            if (testStringType) assert (field.type().asClass().declaration().name().equals("java.lang.String"));
        }

        private static void verifyMethods(ClassInfo clazz) {
            assert (clazz.methods().size() == 18);
            Verifier.assertMethod(clazz, "publicStaticFinalMethod", 1, true, true, false);
            Verifier.assertMethod(clazz, "publicStaticMethod", 1, true, false, false);
            Verifier.assertMethod(clazz, "publicFinalMethod", 1, false, true, false);
            Verifier.assertMethod(clazz, "publicMethod", 1, false, false, false);
            Verifier.assertMethod(clazz, "protectedStaticFinalMethod", 4, true, true, false);
            Verifier.assertMethod(clazz, "protectedStaticMethod", 4, true, false, false);
            Verifier.assertMethod(clazz, "protectedFinalMethod", 4, false, true, false);
            Verifier.assertMethod(clazz, "protectedMethod", 4, false, false, false);
            Verifier.assertMethod(clazz, "packagePrivateStaticFinalMethod", 0, true, true, false);
            Verifier.assertMethod(clazz, "packagePrivateStaticMethod", 0, true, false, false);
            Verifier.assertMethod(clazz, "packagePrivateFinalMethod", 0, false, true, false);
            Verifier.assertMethod(clazz, "packagePrivateMethod", 0, false, false, false);
            Verifier.assertMethod(clazz, "privateStaticFinalMethod", 2, true, true, false);
            Verifier.assertMethod(clazz, "privateStaticMethod", 2, true, false, false);
            Verifier.assertMethod(clazz, "privateFinalMethod", 2, false, true, false);
            Verifier.assertMethod(clazz, "privateMethod", 2, false, false, false);
        }

        static void assertMethod(ClassInfo clazz, String name, int accesibility, boolean isStatic, boolean isFinal, boolean isAbstract) {
            Verifier.assertMethod(clazz, name, accesibility, isStatic, isFinal, isAbstract, true);
        }

        static void assertMethod(ClassInfo clazz, String name, int accesibility, boolean isStatic, boolean isFinal, boolean isAbstract, boolean testVoidType) {
            MethodInfo method = LangModelUtils.singleMethod(clazz, name);
            assert (method.declaringClass().equals(clazz));
            assert (!method.isConstructor());
            assert (Modifier.isPublic(method.modifiers()) == Modifier.isPublic(accesibility));
            assert (Modifier.isProtected(method.modifiers()) == Modifier.isProtected(accesibility));
            assert (Modifier.isPrivate(method.modifiers()) == Modifier.isPrivate(accesibility));
            assert (method.isFinal() == isFinal);
            assert (Modifier.isFinal(method.modifiers()) == isFinal);
            assert (method.isStatic() == isStatic);
            assert (Modifier.isStatic(method.modifiers()) == isStatic);
            assert (method.isAbstract() == isAbstract);
            assert (Modifier.isAbstract(method.modifiers()) == isAbstract);
            if (testVoidType) {
                Verifier.assertType(method.returnType(), Type.Kind.VOID);
            }
        }

        private static void verifyConstructors(ClassInfo clazz) {
            assert (clazz.constructors().size() == 4);
            Verifier.assertConstructor(clazz, PrimitiveType.PrimitiveKind.BOOLEAN, 1);
            Verifier.assertConstructor(clazz, PrimitiveType.PrimitiveKind.INT, 4);
            Verifier.assertConstructor(clazz, PrimitiveType.PrimitiveKind.DOUBLE, 0);
            Verifier.assertConstructor(clazz, PrimitiveType.PrimitiveKind.CHAR, 2);
        }

        static void assertConstructor(ClassInfo clazz, PrimitiveType.PrimitiveKind typeOfFirstParam, int accesibility) {
            MethodInfo ctor = clazz.constructors().stream().filter(it -> {
                Type firstParamType = ((ParameterInfo)it.parameters().get(0)).type();
                return firstParamType.isPrimitive() && firstParamType.asPrimitive().primitiveKind() == typeOfFirstParam;
            }).findAny().get();
            assert (ctor.name().equals(clazz.name()));
            assert (ctor.declaringClass().equals(clazz));
            assert (ctor.isConstructor());
            assert (Modifier.isPublic(ctor.modifiers()) == Modifier.isPublic(accesibility));
            assert (Modifier.isProtected(ctor.modifiers()) == Modifier.isProtected(accesibility));
            assert (Modifier.isPrivate(ctor.modifiers()) == Modifier.isPrivate(accesibility));
            assert (!ctor.isStatic());
            assert (!ctor.isAbstract());
            assert (!ctor.isFinal());
            assert (ctor.returnType().asClass().declaration().equals(clazz));
            assert (ctor.parameters().size() == 1);
        }

        static void assertType(Type type, Type.Kind expectedKind) {
            assert (type.kind() == expectedKind);
            assert (type.isVoid() == (expectedKind == Type.Kind.VOID));
            assert (type.isPrimitive() == (expectedKind == Type.Kind.PRIMITIVE));
            assert (type.isClass() == (expectedKind == Type.Kind.CLASS));
            assert (type.isArray() == (expectedKind == Type.Kind.ARRAY));
            assert (type.isParameterizedType() == (expectedKind == Type.Kind.PARAMETERIZED_TYPE));
            assert (type.isTypeVariable() == (expectedKind == Type.Kind.TYPE_VARIABLE));
            assert (type.isWildcardType() == (expectedKind == Type.Kind.WILDCARD_TYPE));
        }
    }
}

