/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.navigator;

import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.IllegalTransitionException;
import com.ibm.jbatch.container.jsl.Transition;
import com.ibm.jbatch.container.navigator.AbstractNavigatorImpl;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.jsl.model.JSLJob;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobNavigatorImpl
extends AbstractNavigatorImpl<JSLJob>
implements ModelNavigator<JSLJob> {
    private static final Logger logger = Logger.getLogger(JobNavigatorImpl.class.getName());
    private JSLJob job = null;

    public JobNavigatorImpl(JSLJob job) {
        this.job = job;
    }

    public String toString() {
        return "JobNavigatorImpl for job id = " + this.job.getId();
    }

    @Override
    public ExecutionElement getFirstExecutionElement(String restartOn) throws IllegalTransitionException {
        logger.fine("Getting first execution element in job, restartOn = " + restartOn);
        ExecutionElement firstElem = this.getFirstExecutionElement(this.job.getExecutionElements(), restartOn);
        logger.fine("Got first execution element in job = " + firstElem.getId());
        return firstElem;
    }

    @Override
    public ExecutionElement getFirstExecutionElement() throws IllegalTransitionException {
        return this.getFirstExecutionElement(null);
    }

    @Override
    public Transition getNextTransition(ExecutionElement currentExecutionElem, ExecutionStatus currentStatus) throws IllegalTransitionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting next transition in job, currentExecutionElem = " + currentExecutionElem);
        }
        Transition nextTransition = this.getNextTransition(currentExecutionElem, this.job.getExecutionElements(), currentStatus);
        logger.fine("Got next transition in job = " + nextTransition);
        return nextTransition;
    }

    @Override
    public JSLJob getRootModelElement() {
        return this.job;
    }
}

