/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.handlers;

import com.sun.messaging.bridge.admin.BridgeServiceManagerImpl;
import com.sun.messaging.bridge.admin.handlers.AdminCmdHandler;
import com.sun.messaging.bridge.admin.handlers.AdminMessageHandler;
import com.sun.messaging.bridge.admin.resources.BridgeManagerResources;
import com.sun.messaging.bridge.admin.util.AdminMessageType;
import com.sun.messaging.bridge.api.BridgeException;
import com.sun.messaging.bridge.api.FaultInjection;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import java.util.Properties;

public class DebugHandler
extends AdminCmdHandler {
    public DebugHandler(AdminMessageHandler parent, BridgeServiceManagerImpl bsm) {
        super(parent, bsm);
    }

    @Override
    public void handle(Session session, ObjectMessage msg, ObjectMessage reply, BridgeManagerResources bmr) throws BridgeException, Exception {
        int msgtype = msg.getIntProperty("JMQMessageType");
        if (msgtype != 16) {
            throw new BridgeException("Unexpected bridge admin message type " + AdminMessageType.getString(msgtype));
        }
        String debugArg = msg.getStringProperty("JMQCommandArg");
        String target = msg.getStringProperty("JMQTarget");
        if (debugArg == null) {
            throw new BridgeException(this._bmr.getKString("BB4014"));
        }
        if (!debugArg.trim().equals("fault")) {
            throw new BridgeException(this._bmr.getKString("BB4015", debugArg));
        }
        if (target == null || target.trim().length() == 0) {
            throw new BridgeException(this._bmr.getKString("BB4016", debugArg));
        }
        Properties props = (Properties)msg.getObject();
        String faultName = target;
        String faultSelector = props.getProperty("selector");
        FaultInjection fi = FaultInjection.getInjection();
        String enabledStr = props.getProperty("enabled");
        if (enabledStr != null && enabledStr.equalsIgnoreCase("false")) {
            fi.unsetFault(faultName);
        } else {
            fi.setFaultInjection(true);
            try {
                fi.setFault(faultName, faultSelector, props);
            }
            catch (Exception e) {
                this._bc.logError(this._bmr.getKString("BB3008", faultName), e);
                throw e;
            }
        }
        this.parent.sendReply(session, (Message)msg, reply, 200, null, bmr);
    }
}

