/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.enterprise.inject.spi.ProcessSessionBean;
import jakarta.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessSyntheticBean;
import jakarta.enterprise.inject.spi.ProcessSyntheticObserverMethod;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jboss.weld.bootstrap.SyntheticExtension;
import org.jboss.weld.bootstrap.event.WeldAfterBeanDiscovery;
import org.jboss.weld.bootstrap.event.WeldProcessManagedBean;
import org.jboss.weld.bootstrap.events.NotificationListener;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.event.ContainerLifecycleEventObserverMethod;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.reflection.Reflections;

public final class ContainerLifecycleObserver<T>
implements ContainerLifecycleEventObserverMethod<T> {
    private final int priority;
    private final Type observedType;
    private final BiConsumer<T, BeanManager> callbackWithBeanManager;
    private final Consumer<T> callback;
    private final Collection<Class<? extends Annotation>> requiredAnnotations;
    private volatile BeanManager beanManager;
    private volatile SyntheticExtension extension;

    public static Builder<BeforeBeanDiscovery> beforeBeanDiscovery() {
        return ContainerLifecycleObserver.of(BeforeBeanDiscovery.class);
    }

    public static ContainerLifecycleObserver<BeforeBeanDiscovery> beforeBeanDiscovery(Consumer<BeforeBeanDiscovery> callback) {
        return ContainerLifecycleObserver.beforeBeanDiscovery().notify(callback);
    }

    public static Builder<WeldAfterBeanDiscovery> afterBeanDiscovery() {
        return ContainerLifecycleObserver.of(WeldAfterBeanDiscovery.class);
    }

    public static ContainerLifecycleObserver<WeldAfterBeanDiscovery> afterBeanDiscovery(Consumer<WeldAfterBeanDiscovery> callback) {
        return ContainerLifecycleObserver.afterBeanDiscovery().notify(callback);
    }

    public static Builder<AfterTypeDiscovery> afterTypeDiscovery() {
        return ContainerLifecycleObserver.of(AfterTypeDiscovery.class);
    }

    public static ContainerLifecycleObserver<AfterTypeDiscovery> afterTypeDiscovery(Consumer<AfterTypeDiscovery> callback) {
        return ContainerLifecycleObserver.afterTypeDiscovery().notify(callback);
    }

    public static Builder<AfterDeploymentValidation> afterDeploymentValidation() {
        return ContainerLifecycleObserver.of(AfterDeploymentValidation.class);
    }

    public static ContainerLifecycleObserver<AfterDeploymentValidation> afterDeploymentValidation(Consumer<AfterDeploymentValidation> callback) {
        return ContainerLifecycleObserver.afterDeploymentValidation().notify(callback);
    }

    public static Builder<BeforeShutdown> beforeShutdown() {
        return ContainerLifecycleObserver.of(BeforeShutdown.class);
    }

    public static ContainerLifecycleObserver<BeforeShutdown> beforeShutdown(Consumer<BeforeShutdown> callback) {
        return ContainerLifecycleObserver.beforeShutdown().notify(callback);
    }

    public static Builder<ProcessAnnotatedType<?>> processAnnotatedType() {
        return ContainerLifecycleObserver.processAnnotatedType(new TypeLiteral<ProcessAnnotatedType<?>>(){}.getType());
    }

    public static Builder<ProcessAnnotatedType<?>> processAnnotatedType(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessAnnotatedType.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessSyntheticAnnotatedType<?>> processSyntheticAnnotatedType(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessSyntheticAnnotatedType.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessInjectionPoint<?, ?>> processInjectionPoint() {
        return ContainerLifecycleObserver.processInjectionPoint(new TypeLiteral<ProcessInjectionPoint<?, ?>>(){}.getType());
    }

    public static Builder<ProcessInjectionPoint<?, ?>> processInjectionPoint(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessInjectionPoint.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessInjectionTarget<?>> processInjectionTarget() {
        return ContainerLifecycleObserver.processInjectionTarget(new TypeLiteral<ProcessInjectionTarget<?>>(){}.getType());
    }

    public static Builder<ProcessInjectionTarget<?>> processInjectionTarget(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessInjectionTarget.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessBeanAttributes<?>> processBeanAttributes() {
        return ContainerLifecycleObserver.processBeanAttributes(new TypeLiteral<ProcessBeanAttributes<?>>(){}.getType());
    }

    public static Builder<ProcessBeanAttributes<?>> processBeanAttributes(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessBeanAttributes.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessBean<?>> processBean() {
        return ContainerLifecycleObserver.processBean(new TypeLiteral<ProcessBean<?>>(){}.getType());
    }

    public static Builder<ProcessBean<?>> processBean(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessBean.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<WeldProcessManagedBean<?>> processManagedBean() {
        return ContainerLifecycleObserver.processManagedBean(new TypeLiteral<WeldProcessManagedBean<?>>(){}.getType());
    }

    public static Builder<WeldProcessManagedBean<?>> processManagedBean(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, WeldProcessManagedBean.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessSessionBean<?>> processSessionBean() {
        return ContainerLifecycleObserver.processSessionBean(new TypeLiteral<ProcessSessionBean<?>>(){}.getType());
    }

    public static Builder<ProcessSessionBean<?>> processSessionBean(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessSessionBean.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessProducerMethod<?, ?>> processProducerMethod() {
        return ContainerLifecycleObserver.processProducerMethod(new TypeLiteral<ProcessProducerMethod<?, ?>>(){}.getType());
    }

    public static Builder<ProcessProducerMethod<?, ?>> processProducerMethod(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessProducerMethod.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessProducerField<?, ?>> processProducerField() {
        return ContainerLifecycleObserver.processProducerField(new TypeLiteral<ProcessProducerField<?, ?>>(){}.getType());
    }

    public static Builder<ProcessProducerField<?, ?>> processProducerField(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessProducerField.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessSyntheticBean<?>> processSyntheticBean() {
        return ContainerLifecycleObserver.processSyntheticBean(new TypeLiteral<ProcessSyntheticBean<?>>(){}.getType());
    }

    public static Builder<ProcessSyntheticBean<?>> processSyntheticBean(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessSyntheticBean.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessProducer<?, ?>> processProducer() {
        return ContainerLifecycleObserver.processProducer(new TypeLiteral<ProcessProducer<?, ?>>(){}.getType());
    }

    public static Builder<ProcessProducer<?, ?>> processProducer(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessProducer.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessObserverMethod<?, ?>> processObserverMethod() {
        return ContainerLifecycleObserver.processObserverMethod(new TypeLiteral<ProcessObserverMethod<?, ?>>(){}.getType());
    }

    public static Builder<ProcessObserverMethod<?, ?>> processObserverMethod(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessObserverMethod.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    public static Builder<ProcessSyntheticObserverMethod<?, ?>> processSyntheticObserverMethod() {
        return ContainerLifecycleObserver.processSyntheticObserverMethod(new TypeLiteral<ProcessSyntheticObserverMethod<?, ?>>(){}.getType());
    }

    public static Builder<ProcessSyntheticObserverMethod<?, ?>> processSyntheticObserverMethod(Type observedType) {
        ContainerLifecycleObserver.checkRawType(observedType, ProcessSyntheticObserverMethod.class);
        return ContainerLifecycleObserver.of(observedType);
    }

    private ContainerLifecycleObserver(int priority, Type observedType, BiConsumer<T, BeanManager> callbackWithBeanManager, Consumer<T> callback, Collection<Class<? extends Annotation>> requiredAnnotations) {
        this.priority = priority;
        this.observedType = observedType;
        this.callbackWithBeanManager = callbackWithBeanManager;
        this.callback = callback;
        this.requiredAnnotations = requiredAnnotations;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Class<?> getBeanClass() {
        return ContainerLifecycleObserver.class;
    }

    @Override
    public Type getObservedType() {
        return this.observedType;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return Collections.emptySet();
    }

    @Override
    public Reception getReception() {
        return Reception.ALWAYS;
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return TransactionPhase.IN_PROGRESS;
    }

    @Override
    public void notify(T event) {
        if (this.beanManager == null || this.extension == null) {
            throw WeldSELogger.LOG.containerLifecycleObserverNotInitialized(this.toString());
        }
        if (event instanceof NotificationListener) {
            ((NotificationListener)NotificationListener.class.cast(event)).preNotify(this.extension);
        }
        try {
            if (this.callbackWithBeanManager != null) {
                this.callbackWithBeanManager.accept(event, this.beanManager);
            } else {
                this.callback.accept(event);
            }
        }
        finally {
            if (event instanceof NotificationListener) {
                ((NotificationListener)NotificationListener.class.cast(event)).postNotify(null);
            }
        }
    }

    @Override
    public Collection<Class<? extends Annotation>> getRequiredAnnotations() {
        return this.requiredAnnotations;
    }

    private void setBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    private void setExtension(SyntheticExtension extension) {
        this.extension = extension;
    }

    public String toString() {
        return String.format("ContainerLifecyleObserver [priority=%s, observedType=%s]", this.priority, this.observedType);
    }

    public static ExtensionBuilder extensionBuilder() {
        return new ExtensionBuilder();
    }

    private static <T> Builder<T> of(Type observedType) {
        if (!Observers.CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(observedType))) {
            throw WeldSELogger.LOG.observedTypeNotContonainerLifecycleEventType(observedType);
        }
        return new Builder(observedType);
    }

    private static void checkRawType(Type observedType, Class<?> rawType) {
        if (!rawType.equals(Reflections.getRawType(observedType))) {
            throw WeldSELogger.LOG.observedTypeDoesNotMatchContonainerLifecycleEventType(observedType, rawType);
        }
    }

    public static class Builder<T> {
        private static final String OBSERVED_TYPE = "observedType";
        private static final String CALLBACK = "callback";
        private static final int DEFAULT_PRIORITY = 2500;
        private int priority = 2500;
        private Type observedType;
        private Collection<Class<? extends Annotation>> requiredAnnotations = Collections.emptySet();

        private Builder(Type observedType) {
            Preconditions.checkArgumentNotNull(observedType, OBSERVED_TYPE);
            this.observedType = observedType;
        }

        public Builder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        @SafeVarargs
        public final Builder<T> withAnnotations(Class<? extends Annotation> ... annotations) {
            this.requiredAnnotations = new HashSet<Class<? extends Annotation>>();
            Collections.addAll(this.requiredAnnotations, annotations);
            return this;
        }

        public ContainerLifecycleObserver<T> notify(BiConsumer<T, BeanManager> callback) {
            Preconditions.checkArgumentNotNull(callback, CALLBACK);
            return new ContainerLifecycleObserver<T>(this.priority, this.observedType, callback, null, this.requiredAnnotations);
        }

        public ContainerLifecycleObserver<T> notify(Consumer<T> callback) {
            Preconditions.checkArgumentNotNull(callback, CALLBACK);
            return new ContainerLifecycleObserver<T>(this.priority, this.observedType, null, callback, this.requiredAnnotations);
        }
    }

    public static class ExtensionBuilder {
        private final List<ContainerLifecycleObserver<?>> observers = new LinkedList();

        private ExtensionBuilder() {
        }

        public ExtensionBuilder add(ContainerLifecycleObserver<?> observer) {
            this.observers.add(observer);
            return this;
        }

        public Extension build() {
            return new ContainerLifecycleObserverExtension(this.observers);
        }
    }

    static class ContainerLifecycleObserverExtension
    implements SyntheticExtension {
        private final List<ContainerLifecycleObserver<?>> observers;

        ContainerLifecycleObserverExtension(List<ContainerLifecycleObserver<?>> observers) {
            this.observers = new ArrayList(observers);
        }

        @Override
        public void initialize(BeanManager beanManager) {
            for (ContainerLifecycleObserver<?> observer : this.observers) {
                observer.setBeanManager(beanManager);
                observer.setExtension(this);
            }
        }

        @Override
        public Collection<ContainerLifecycleEventObserverMethod<?>> getObservers() {
            return (Collection)Reflections.cast(this.observers);
        }
    }
}

