/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.shared.common.error.StandardException;

public final class StatementRoutinePermission
extends StatementPermission {
    private UUID routineUUID;

    public StatementRoutinePermission(UUID uUID) {
        this.routineUUID = uUID;
    }

    public UUID getRoutineUUID() {
        return this.routineUUID;
    }

    @Override
    public void check(LanguageConnectionContext languageConnectionContext, boolean bl, Activation activation) throws StandardException {
        this.genericCheck(languageConnectionContext, bl, activation, "EXECUTE");
    }

    @Override
    public boolean isCorrectPermission(PermissionsDescriptor permissionsDescriptor) {
        if (permissionsDescriptor == null || !(permissionsDescriptor instanceof RoutinePermsDescriptor)) {
            return false;
        }
        RoutinePermsDescriptor routinePermsDescriptor = (RoutinePermsDescriptor)permissionsDescriptor;
        return routinePermsDescriptor.getHasExecutePermission();
    }

    @Override
    public PrivilegedSQLObject getPrivilegedObject(DataDictionary dataDictionary) throws StandardException {
        return dataDictionary.getAliasDescriptor(this.routineUUID);
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        return dataDictionary.getRoutinePermissions(this.routineUUID, string);
    }

    @Override
    public String getObjectType() {
        return "ROUTINE";
    }

    public String toString() {
        return "StatementRoutinePermission: " + this.routineUUID;
    }
}

