/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro;

import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.concurro.AbstractManagedThread;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.ThreadExpiredException;
import org.glassfish.concurro.spi.ContextHandle;
import org.glassfish.concurro.spi.ContextSetupProvider;

public class ManagedThreadFactoryImpl
implements ManagedThreadFactory {
    private List<Thread> threads;
    private boolean stopped = false;
    private Lock lock;
    private String name;
    private final ContextSetupProvider contextSetupProvider;
    private final ContextServiceImpl contextService;
    protected ContextHandle savedContextHandleForSetup = null;
    private int priority;
    private long hungTaskThreshold = 0L;
    private AtomicInteger threadIdSequence = new AtomicInteger();
    public static final String MANAGED_THREAD_FACTORY_STOPPED = "ManagedThreadFactory is stopped";

    public ManagedThreadFactoryImpl(String name) {
        this(name, null, 5);
    }

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService) {
        this(name, contextService, 5);
    }

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService, int priority) {
        this.name = name;
        this.contextService = contextService;
        this.contextSetupProvider = contextService != null ? contextService.getContextSetupProvider() : null;
        this.priority = priority;
        this.threads = new ArrayList<Thread>();
        this.lock = new ReentrantLock();
    }

    public String getName() {
        return this.name;
    }

    public long getHungTaskThreshold() {
        return this.hungTaskThreshold;
    }

    public void setHungTaskThreshold(long hungTaskThreshold) {
        this.hungTaskThreshold = hungTaskThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread newThread(Runnable r) {
        this.lock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException(MANAGED_THREAD_FACTORY_STOPPED);
            }
            ContextHandle contextHandleForSetup = null;
            if (this.savedContextHandleForSetup != null) {
                contextHandleForSetup = this.savedContextHandleForSetup;
            } else if (this.contextSetupProvider != null) {
                contextHandleForSetup = this.contextSetupProvider.saveContext(this.contextService);
            }
            Thread newThread = this.createThread(r, contextHandleForSetup);
            newThread.setDaemon(true);
            this.threads.add(newThread);
            Thread thread = newThread;
            return thread;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Thread createThread(Runnable runnable, ContextHandle contextHandleForSetup) {
        return this.createThreadInternal(runnable, contextHandleForSetup);
    }

    private Thread createThreadInternal(Runnable r, ContextHandle contextHandleForSetup) {
        ManagedThread newThread = new ManagedThread(r, contextHandleForSetup);
        newThread.setPriority(this.priority);
        return newThread;
    }

    protected ForkJoinWorkerThread createWorkerThread(ForkJoinPool forkJoinPool, ContextHandle contextHandleForSetup) {
        return this.createWorkerThreadInternal(forkJoinPool, contextHandleForSetup);
    }

    private WorkerThread createWorkerThreadInternal(ForkJoinPool forkJoinPool, ContextHandle contextHandleForSetup) {
        WorkerThread newThread = new WorkerThread(forkJoinPool, contextHandleForSetup);
        newThread.setPriority(this.priority);
        return newThread;
    }

    protected void removeThread(Thread t) {
        this.lock.lock();
        try {
            this.threads.remove(t);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Collection<Thread> getThreads() {
        ArrayList<Thread> result = null;
        this.lock.lock();
        try {
            if (!this.threads.isEmpty()) {
                result = new ArrayList<Thread>(this.threads);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    public void taskStarting(Thread t, ManagedFutureTask task) {
        if (t instanceof ThreadWithTiming) {
            ThreadWithTiming mt = (ThreadWithTiming)((Object)t);
            mt.notifyTaskStarting(task);
        }
    }

    public void taskDone(Thread t) {
        if (t instanceof ThreadWithTiming) {
            ThreadWithTiming mt = (ThreadWithTiming)((Object)t);
            mt.notifyTaskDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            for (Thread t : this.threads) {
                try {
                    this.shutdown(t);
                    t.interrupt();
                }
                catch (SecurityException securityException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ContextSetupProvider getContextSetupProvider() {
        return this.contextSetupProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        this.lock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException(MANAGED_THREAD_FACTORY_STOPPED);
            }
            ContextHandle contextHandleForSetup = null;
            if (this.savedContextHandleForSetup != null) {
                contextHandleForSetup = this.savedContextHandleForSetup;
            } else if (this.contextSetupProvider != null) {
                contextHandleForSetup = this.contextSetupProvider.saveContext(this.contextService);
            }
            ForkJoinWorkerThread newThread = this.createWorkerThread(pool, contextHandleForSetup);
            this.threads.add(newThread);
            ForkJoinWorkerThread forkJoinWorkerThread = newThread;
            return forkJoinWorkerThread;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void shutdown(Thread t) {
        if (t instanceof AbstractManagedThread) {
            AbstractManagedThread mt = (AbstractManagedThread)t;
            mt.shutdown();
        }
    }

    public class ManagedThread
    extends AbstractManagedThread
    implements ThreadWithTiming {
        final ContextHandle contextHandleForSetup;
        volatile ManagedFutureTask task;
        volatile long taskStartTime;

        public ManagedThread(Runnable target, ContextHandle contextHandleForSetup) {
            super(target);
            this.task = null;
            this.taskStartTime = 0L;
            this.setName(ManagedThreadFactoryImpl.this.name + "-Thread-" + ManagedThreadFactoryImpl.this.threadIdSequence.incrementAndGet());
            this.contextHandleForSetup = contextHandleForSetup;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block11: {
                ContextHandle handle = null;
                try {
                    if (this.contextHandleForSetup != null) {
                        handle = ManagedThreadFactoryImpl.this.contextSetupProvider.setup(this.contextHandleForSetup);
                    }
                    if (this.shutdown) {
                        this.interrupt();
                    }
                    super.run();
                    if (handle == null) break block11;
                }
                catch (ThreadExpiredException ex) {
                    Logger.getLogger("org.glassfish.concurro").log(Level.INFO, ex.toString());
                    if (handle != null) {
                        ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                    }
                    ManagedThreadFactoryImpl.this.removeThread(this);
                }
                catch (Throwable t) {
                    Logger.getLogger("org.glassfish.concurro").log(Level.SEVERE, ManagedThreadFactoryImpl.this.name, t);
                    if (handle != null) {
                        ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                    }
                    ManagedThreadFactoryImpl.this.removeThread(this);
                    {
                        catch (Throwable throwable) {
                            if (handle != null) {
                                ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                            }
                            ManagedThreadFactoryImpl.this.removeThread(this);
                            throw throwable;
                        }
                    }
                }
                ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
            }
            ManagedThreadFactoryImpl.this.removeThread(this);
        }

        @Override
        boolean cancelTask() {
            ManagedFutureTask task = this.task;
            if (task != null) {
                return task.cancel(true);
            }
            return false;
        }

        @Override
        public String getTaskIdentityName() {
            ManagedFutureTask task = this.task;
            if (task != null) {
                return task.getTaskIdentityName();
            }
            return "null";
        }

        @Override
        public long getTaskRunTime(long now) {
            if (this.task != null && this.taskStartTime > 0L) {
                long taskRunTime = now - this.taskStartTime;
                return taskRunTime > 0L ? taskRunTime : 0L;
            }
            return 0L;
        }

        @Override
        public long getThreadStartTime() {
            return this.threadStartTime;
        }

        @Override
        public boolean isTaskHung(long now) {
            if (ManagedThreadFactoryImpl.this.hungTaskThreshold > 0L) {
                return this.getTaskRunTime(now) - ManagedThreadFactoryImpl.this.hungTaskThreshold > 0L;
            }
            return false;
        }

        @Override
        public void notifyTaskDone() {
            this.taskStartTime = 0L;
            this.task = null;
        }

        @Override
        public void notifyTaskStarting(ManagedFutureTask task) {
            this.taskStartTime = System.currentTimeMillis();
            this.task = task;
        }
    }

    class WorkerThread
    extends ForkJoinWorkerThread
    implements ThreadWithTiming {
        public static final long NOT_STARTED = -1L;
        volatile long taskStartTime;
        final ContextHandle contextHandleForSetup;

        public WorkerThread(ForkJoinPool pool, ContextHandle contextHandleForSetup) {
            super(pool);
            this.taskStartTime = -1L;
            this.contextHandleForSetup = contextHandleForSetup;
        }

        @Override
        protected void onTermination(Throwable exception) {
            super.onTermination(exception);
        }

        @Override
        public void run() {
            try {
                if (this.contextHandleForSetup != null) {
                    ManagedThreadFactoryImpl.this.contextSetupProvider.setup(this.contextHandleForSetup);
                }
                super.run();
            }
            catch (ThreadExpiredException ex) {
                Logger.getLogger("org.glassfish.concurro").log(Level.INFO, ex.toString());
            }
            catch (Throwable t) {
                Logger.getLogger("org.glassfish.concurro").log(Level.SEVERE, ManagedThreadFactoryImpl.this.name, t);
            }
        }

        @Override
        public boolean isTaskHung(long now) {
            return this.taskStartTime != -1L && now - this.taskStartTime > ManagedThreadFactoryImpl.this.hungTaskThreshold;
        }

        @Override
        public void notifyTaskDone() {
            this.taskStartTime = -1L;
        }

        @Override
        public void notifyTaskStarting(ManagedFutureTask task) {
            this.taskStartTime = System.currentTimeMillis();
        }
    }

    public static interface ThreadWithTiming {
        public void notifyTaskDone();

        public void notifyTaskStarting(ManagedFutureTask var1);

        public boolean isTaskHung(long var1);
    }
}

