/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public class LocalDateTime
extends AbstractExpression {
    private Identifier identifier;

    public LocalDateTime(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = Identifier.parse(wordParser);
        this.setText(this.identifier.name);
        wordParser.moveForward(this.identifier.name);
    }

    public void runByType(Runnable dateAction, Runnable timeAction, Runnable dateTimeAction) {
        switch ((this.identifier != null ? this.identifier : Identifier.getIdentifier(this.getText())).ordinal()) {
            case 0: {
                dateAction.run();
                return;
            }
            case 2: {
                timeAction.run();
                return;
            }
            case 1: {
                dateTimeAction.run();
                return;
            }
        }
        throw new IllegalStateException("Unknown value of " + this.getText() + " LocalDateTime expression");
    }

    public <R> R getValueByType(Supplier<R> dateAction, Supplier<R> timeAction, Supplier<R> dateTimeAction) {
        return switch ((this.identifier != null ? this.identifier : Identifier.getIdentifier(this.getText())).ordinal()) {
            case 0 -> dateAction.get();
            case 2 -> timeAction.get();
            case 1 -> dateTimeAction.get();
            default -> throw new IllegalStateException("Unknown value of " + this.getText() + " LocalDateTime expression");
        };
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("local_datetime_type");
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier.name : this.getText());
    }

    @Override
    public String toActualText() {
        return this.getText();
    }

    private static enum Identifier {
        DATE("date"),
        DATETIME("datetime"),
        TIME("time");

        private final String name;

        private Identifier(String name) {
            this.name = name;
        }

        private static Identifier getIdentifier(String name) {
            return switch (name.toUpperCase()) {
                case "DATE" -> DATE;
                case "TIME" -> TIME;
                case "DATETIME" -> DATETIME;
                default -> null;
            };
        }

        private static Identifier parse(WordParser wordParser) {
            int position = wordParser.position();
            return switch (wordParser.character(position)) {
                case 'D', 'd' -> {
                    switch (wordParser.character(position + 4)) {
                        case 'T': 
                        case 't': {
                            yield DATETIME;
                        }
                    }
                    yield DATE;
                }
                default -> TIME;
            };
        }
    }
}

