/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransaction2PCompleteEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransaction2PPrepareEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.HashSet;

public class ClusterTransactionManager
extends BaseTransactionManager {
    ClusterTransactionManager(TransactionLogManager transactionLogManager) {
        super(transactionLogManager);
    }

    @Override
    void processStoredTxnOnStartup(BaseTransaction baseTxn) {
        int state;
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processStoredTxnOnStartup " + String.valueOf(baseTxn);
            logger.log(4, msg);
        }
        if ((state = baseTxn.getState()) == 6 || state == 7) {
            this.addToCompleteStored(baseTxn);
        } else if (state == 5) {
            this.addToIncompleteStored(baseTxn);
        }
    }

    @Override
    TransactionEvent generateEvent(BaseTransaction baseTxn, boolean completion) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " generateEvent " + String.valueOf(baseTxn);
            logger.log(4, msg);
        }
        ClusterTransactionEvent result = null;
        if (completion) {
            result = new ClusterTransaction2PCompleteEvent();
        } else if (baseTxn.getState() == 5) {
            result = new ClusterTransaction2PPrepareEvent();
        } else {
            throw new UnsupportedOperationException();
        }
        result.clusterTransaction = (ClusterTransaction)baseTxn;
        return result;
    }

    @Override
    void processTxn(BaseTransaction baseTxn) throws IOException, BrokerException {
        int state;
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processTxn " + String.valueOf(baseTxn);
            logger.log(4, msg);
        }
        if ((state = baseTxn.getState()) != 5) {
            throw new UnsupportedOperationException();
        }
        this.addToIncompleteUnstored(baseTxn);
    }

    @Override
    BaseTransaction processTxnCompletion(TransactionUID tid, int state) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processTxnCompletion " + String.valueOf(tid);
            logger.log(4, msg);
        }
        boolean removeFromStore = false;
        return this.processTxnCompletion(tid, state, removeFromStore);
    }

    void updateTransactionBrokerState(TransactionUID tid, int expectedTxnState, TransactionBroker txnBkr, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " updateTransactionBrokerState: tx = " + String.valueOf(tid) + " txnBkr=" + String.valueOf(txnBkr);
            Globals.getLogger().log(4, msg);
        }
        ClusterTransaction clusterTxn = null;
        boolean stored = false;
        clusterTxn = (ClusterTransaction)this.incompleteUnstored.get(tid);
        if (clusterTxn == null && (clusterTxn = (ClusterTransaction)this.incompleteStored.get(tid)) != null) {
            stored = true;
        }
        if (clusterTxn != null) {
            boolean allComplete = this.updateTransactionBrokerState(txnBkr, clusterTxn);
            if (Store.getDEBUG()) {
                Globals.getLogger().log(4, this.getPrefix() + " allComplete:  = " + allComplete);
            }
            if (allComplete) {
                clusterTxn.getTransactionDetails().setComplete(true);
                if (!stored) {
                    this.removeFromIncompleteUnstored(tid);
                } else {
                    this.removeFromIncompleteStored(tid);
                    this.addToCompleteStored(clusterTxn);
                    try {
                        this.updateStoredCompletion(tid, true);
                    }
                    catch (IOException ioe) {
                        throw new BrokerException("Could not update completion state of stored cluster transaction " + String.valueOf(tid), ioe);
                    }
                }
            }
        } else {
            logger.log(32, "Could not find matching cluster transaction for " + String.valueOf(tid));
        }
    }

    boolean updateTransactionBrokerState(TransactionBroker txnBkr, ClusterTransaction clusterTxn) {
        TransactionBroker[] txnBrokers = clusterTxn.getTransactionBrokers();
        TransactionBroker result = null;
        BrokerAddress b = txnBkr.getBrokerAddress();
        boolean allComplete = true;
        for (int i = 0; i < txnBrokers.length; ++i) {
            BrokerAddress ba = txnBrokers[i].getCurrentBrokerAddress();
            if (ba == null) continue;
            if (ba.equals(b)) {
                result = txnBrokers[i];
                continue;
            }
            allComplete &= txnBrokers[i].isCompleted();
        }
        result.setCompleted(true);
        return allComplete;
    }

    @Override
    void replayTransactionEvent(TransactionEvent txnEvent, HashSet dstLoadedSet) throws BrokerException, IOException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " replayTransactionEvent");
        }
        ClusterTransactionEvent clusterTxnEvent = (ClusterTransactionEvent)txnEvent;
        ClusterTransaction clusterTxn = clusterTxnEvent.clusterTransaction;
        int state = clusterTxn.getState();
        TransactionUID tid = clusterTxn.getTid();
        if (clusterTxnEvent.getSubType() == 1) {
            if (this.incompleteStored.containsKey(tid)) {
                if (Store.getDEBUG()) {
                    String msg = this.getPrefix() + " found matching txn in prepared store on replay " + String.valueOf(clusterTxn);
                    Globals.getLogger().log(4, msg);
                }
            } else {
                this.addToIncompleteUnstored(clusterTxn);
            }
        } else if (clusterTxnEvent.getSubType() == 2) {
            BaseTransaction existingWork = null;
            if (this.incompleteUnstored.containsKey(tid)) {
                if (state == 7) {
                    existingWork = this.removeFromIncompleteUnstored(tid);
                } else if (state == 6) {
                    existingWork = (BaseTransaction)this.incompleteUnstored.get(tid);
                    existingWork.getTransactionDetails().setState(state);
                    existingWork.getTransactionState().setState(state);
                }
            } else if (this.incompleteStored.containsKey(tid)) {
                existingWork = this.removeFromIncompleteStored(tid);
                this.updateStoredState(tid, state);
                this.addToCompleteStored(existingWork);
            } else if (this.completeStored.containsKey(tid)) {
                existingWork = (BaseTransaction)this.completeStored.get(tid);
            }
            if (existingWork != null) {
                if (state == 6) {
                    this.transactionLogManager.transactionLogReplayer.replayTransactionWork(existingWork.getTransactionWork(), tid, dstLoadedSet);
                }
            } else {
                logger.log(32, "Could not find prepared work for completing two-phase transaction " + String.valueOf(clusterTxn.getTid()));
            }
        }
    }

    @Override
    String getPrefix() {
        return "ClusterTransactionManager: " + Thread.currentThread().getName();
    }
}

