/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionFactory;
import org.glassfish.pfl.dynamic.codegen.impl.MethodInfoBase;
import org.glassfish.pfl.dynamic.codegen.impl.VariableInternal;
import org.glassfish.pfl.dynamic.codegen.spi.ClassInfo;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.copyobject.spi.Immutable;

@Immutable
public class MethodInfoReflectiveImpl
extends MethodInfoBase {
    private Method method = null;
    private Constructor constructor = null;

    public MethodInfoReflectiveImpl(ClassInfo cinfo, Constructor constructor) {
        super(cinfo, constructor.getModifiers());
        this.constructor = constructor;
        this.init(constructor.getExceptionTypes(), constructor.getParameterTypes());
    }

    public MethodInfoReflectiveImpl(ClassInfo cinfo, Method method) {
        super(cinfo, method.getModifiers(), Type.type(method.getReturnType()), method.getName());
        this.method = method;
        this.init(method.getExceptionTypes(), method.getParameterTypes());
    }

    private void init(Class<?>[] exceptions, Class<?>[] arguments) {
        ExpressionFactory ef = new ExpressionFactory(null);
        for (Class<?> cls : exceptions) {
            this.exceptions.add(Type.type(cls));
        }
        int ctr = 0;
        for (Class<?> cls : arguments) {
            String name = "arg" + ctr++;
            VariableInternal var = (VariableInternal)ef.variable(Type.type(cls), name);
            var.close();
            this.arguments.add(var);
        }
    }

    @Override
    public Method getMethod() {
        if (this.isConstructor()) {
            throw new IllegalStateException("Cannot obtain a Method from a MethodInfo that represents a Constructor");
        }
        return this.method;
    }

    @Override
    public Constructor getConstructor() {
        if (!this.isConstructor()) {
            throw new IllegalStateException("Cannot obtain a Constructor from a MethodInfo that represents a Method");
        }
        return this.constructor;
    }
}

