/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.VersionConsistencyCache;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerWrapper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistencyCacheImpl;
import com.sun.jdo.spi.persistence.utility.BucketizedHashtable;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.persistence.common.I18NHelper;

public class SQLPersistenceManagerFactory
implements PersistenceManagerFactory {
    private PersistenceStore _store;
    private ConnectionFactory _connectionFactory;
    private Object _dataSource;
    private com.sun.jdo.api.persistence.support.PersistenceManagerFactory _persistenceManagerFactory;
    private int minPool;
    private int maxPool;
    private static Logger logger = LogHelperPersistenceManager.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)SQLPersistenceManagerFactory.class.getClassLoader());
    private static int pmCacheBucketSize = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory.pmCacheBucketSize", 11);
    private static int pmCacheInitialCapacity = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory.pmCacheInitialCapacity", 11 * pmCacheBucketSize);
    private final Map pmCache = new BucketizedHashtable(pmCacheBucketSize, pmCacheInitialCapacity);
    private VersionConsistencyCache vcCache;

    public SQLPersistenceManagerFactory() {
    }

    public SQLPersistenceManagerFactory(Object connectionFactory) {
        if (connectionFactory instanceof ConnectionFactory) {
            this._connectionFactory = (ConnectionFactory)connectionFactory;
        } else {
            this._dataSource = connectionFactory;
        }
        if (this instanceof com.sun.jdo.api.persistence.support.PersistenceManagerFactory) {
            this._persistenceManagerFactory = this;
        }
        this.initialize();
    }

    public SQLPersistenceManagerFactory(com.sun.jdo.api.persistence.support.PersistenceManagerFactory persistenceManagerFactory) {
        this._persistenceManagerFactory = persistenceManagerFactory;
        Object cf = this._persistenceManagerFactory.getConnectionFactory();
        if (cf instanceof ConnectionFactory) {
            this._connectionFactory = (ConnectionFactory)cf;
        } else {
            this._dataSource = cf;
        }
        this.initialize();
    }

    public void setConnectionUserName(String userName) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public String getConnectionUserName() {
        return this._persistenceManagerFactory.getConnectionUserName();
    }

    public void setConnectionPassword(char[] password) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public void setConnectionURL(String url) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public String getConnectionURL() {
        return this._persistenceManagerFactory.getConnectionURL();
    }

    public void setConnectionDriverName(String driverName) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public String getConnectionDriverName() {
        return this._persistenceManagerFactory.getConnectionDriverName();
    }

    public void setConnectionFactory(Object cf) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public Object getConnectionFactory() {
        if (this._dataSource != null) {
            return this._dataSource;
        }
        return this._connectionFactory;
    }

    public void setOptimistic(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getOptimistic() {
        return this._persistenceManagerFactory.getOptimistic();
    }

    public void setRetainValues(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getRetainValues() {
        return this._persistenceManagerFactory.getRetainValues();
    }

    public void setNontransactionalRead(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getNontransactionalRead() {
        return this._persistenceManagerFactory.getNontransactionalRead();
    }

    public void setIgnoreCache(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getIgnoreCache() {
        return this._persistenceManagerFactory.getIgnoreCache();
    }

    public void setQueryTimeout(int timeout) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getQueryTimeout() {
        return this._persistenceManagerFactory.getQueryTimeout();
    }

    public void setConnectionMaxPool(int MaxPool) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionMaxPool() {
        return this._persistenceManagerFactory.getConnectionMaxPool();
    }

    public void setConnectionMinPool(int MinPool) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionMinPool() {
        return this._persistenceManagerFactory.getConnectionMinPool();
    }

    public void setConnectionMsWait(int MsWait) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionMsWait() {
        return this._persistenceManagerFactory.getConnectionMsWait();
    }

    public void setConnectionMsInterval(int MsInterval) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionMsInterval() {
        return this._persistenceManagerFactory.getConnectionMsInterval();
    }

    public void setConnectionLoginTimeout(int LoginTimeout) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionLoginTimeout() {
        return this._persistenceManagerFactory.getConnectionLoginTimeout();
    }

    public void setConnectionLogWriter(PrintWriter pw) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public PrintWriter getConnectionLogWriter() {
        return this._persistenceManagerFactory.getConnectionLogWriter();
    }

    public void setConnectionTransactionIsolation(int level) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionTransactionIsolation() {
        return this._persistenceManagerFactory.getConnectionTransactionIsolation();
    }

    public void setConnectionFactoryName(SimpleJndiName connectionFactoryName) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public SimpleJndiName getConnectionFactoryName() {
        return this._persistenceManagerFactory.getConnectionFactoryName();
    }

    public void setIdentifier(String identifier) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public String getIdentifier() {
        return this._persistenceManagerFactory.getIdentifier();
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public void setMaxPool(int MaxPool) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getMinPool() {
        return this.minPool;
    }

    public void setMinPool(int MinPool) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public void setUpdateTimeout(int timeout) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getUpdateTimeout() {
        return this._persistenceManagerFactory.getUpdateTimeout();
    }

    public boolean getSupersedeDeletedInstance() {
        return this._persistenceManagerFactory.getSupersedeDeletedInstance();
    }

    public void setSupersedeDeletedInstance(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getRequireCopyObjectId() {
        return this._persistenceManagerFactory.getRequireCopyObjectId();
    }

    public void setRequireCopyObjectId(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getRequireTrackedSCO() {
        return this._persistenceManagerFactory.getRequireTrackedSCO();
    }

    public void setRequireTrackedSCO(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(null, null);
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager(String username, char[] password) {
        Object[] items;
        boolean debug = logger.isLoggable(300);
        if (this._connectionFactory == null && this._dataSource == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.getpersistencemanager.notconfigured"));
        }
        if (debug) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr", (Object)Thread.currentThread());
        }
        PersistenceManagerImpl pm = null;
        jakarta.transaction.Transaction t = EJBHelper.getTransaction();
        if (t != null) {
            if (debug) {
                items = new Object[]{Thread.currentThread(), t};
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.found", items);
            }
            if ((pm = (PersistenceManagerImpl)this.pmCache.get(t)) == null) {
                pm = this.getFromPool(t, username, password);
                this.pmCache.put(t, pm);
            } else if (pm.isClosed()) {
                if (debug) {
                    items = new Object[]{Thread.currentThread(), t};
                    logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.pmclosedfor", items);
                }
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.getpersistencemanager.closed", (Object[])new Object[]{t}));
            }
            Transaction tx = (Transaction)pm.currentTransaction();
            if (debug) {
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.jdotx", (Object)tx);
            }
            if (!tx.isActive()) {
                tx.begin(t);
            }
            if (!pm.verify(username, password)) {
                throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.getpersistencemanager.error"));
            }
        } else {
            if (debug) {
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.jdotx.notfound");
            }
            pm = this.getFromPool(null, username, password);
        }
        if (debug) {
            items = new Object[]{Thread.currentThread(), pm, t};
            logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.pmt", items);
        }
        return new PersistenceManagerWrapper(pm);
    }

    public Properties getProperties() {
        return this._persistenceManagerFactory.getProperties();
    }

    public com.sun.jdo.api.persistence.support.PersistenceManagerFactory getPersistenceManagerFactory() {
        return this._persistenceManagerFactory;
    }

    @Override
    public void registerPersistenceManager(PersistenceManager pm, jakarta.transaction.Transaction t) {
        com.sun.jdo.api.persistence.support.PersistenceManager pm1;
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{pm, t};
            logger.finest("sqlstore.sqlpersistencemgrfactory.registerpersistencemgr.pmt", items);
        }
        if ((pm1 = (com.sun.jdo.api.persistence.support.PersistenceManager)this.pmCache.get(t)) == null) {
            this.pmCache.put(t, pm);
            ((PersistenceManagerImpl)pm).setJTATransaction(t);
            return;
        }
        if (pm1 != pm) {
            Object[] items = new Object[]{t, pm1};
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.registerpm.registered", (Object[])items));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceManagerImpl getFromPool(jakarta.transaction.Transaction tx, String username, char[] password) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.getfrompool");
        }
        SQLPersistenceManagerFactory sQLPersistenceManagerFactory = this;
        synchronized (sQLPersistenceManagerFactory) {
            if (this._store == null) {
                this.initializeSQLStoreManager(username, password);
            }
        }
        PersistenceManagerImpl pm = new PersistenceManagerImpl(this, tx, username, password);
        pm.setStore(this._store);
        if (debug) {
            Object[] items = new Object[]{pm, tx};
            logger.finest("sqlstore.sqlpersistencemgrfactory.getfrompool.pmt", items);
        }
        return pm;
    }

    private void returnToPool(com.sun.jdo.api.persistence.support.PersistenceManager pm) {
        logger.finest("sqlstore.sqlpersistencemgrfactory.returnToPool");
    }

    @Override
    public void releasePersistenceManager(PersistenceManager pm, jakarta.transaction.Transaction t) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{pm, t};
            logger.finest("sqlstore.sqlpersistencemgrfactory.releasepm.pmt", items);
        }
        if (t != null) {
            com.sun.jdo.api.persistence.support.PersistenceManager pm1 = (com.sun.jdo.api.persistence.support.PersistenceManager)this.pmCache.get(t);
            if (pm1 == null || pm1 != pm) {
                Object[] items = new Object[]{t, pm1};
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.registerpm.registered", (Object[])items));
            }
            this.pmCache.remove(t);
        } else {
            this.returnToPool(pm);
        }
    }

    private void initialize() {
        logger.finest("sqlstore.sqlpersistencemgrfactory.init");
        this.minPool = this._persistenceManagerFactory.getMinPool();
        this.maxPool = this._persistenceManagerFactory.getMaxPool();
    }

    private void initializeSQLStoreManager(String username, char[] password) {
        Connection conn = null;
        try {
            conn = this.getConnection(username, password);
            if (conn != null) {
                this._store = new SQLStoreManager(conn.getMetaData(), this.getIdentifier());
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(900)) {
                logger.log(900, "jdo.sqlpersistencemanagerfactory.errorgettingDatabaseInfo", (Throwable)e);
            }
            if (e instanceof JDOException) {
                throw (JDOException)((Object)e);
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.configuration.getvendortypefailed"), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Connection getConnection(String username, char[] password) throws SQLException {
        Connection conn = null;
        conn = this._connectionFactory != null ? this._connectionFactory.getConnection() : (EJBHelper.isManaged() ? EJBHelper.getConnection(this._dataSource, username, password) : (username == null ? ((DataSource)this._dataSource).getConnection() : ((DataSource)this._dataSource).getConnection(username, new String(password))));
        return conn;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SQLPersistenceManagerFactory) {
            SQLPersistenceManagerFactory pmf = (SQLPersistenceManagerFactory)obj;
            return pmf._persistenceManagerFactory.equals((Object)this._persistenceManagerFactory);
        }
        return false;
    }

    public int hashCode() {
        return this._persistenceManagerFactory.hashCode();
    }

    @Override
    public VersionConsistencyCache getVersionConsistencyCache() {
        if (null == this.vcCache) {
            if (this._store == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerfactoryimpl.getversionconsistencycache.nullstore"));
            }
            this.vcCache = VersionConsistencyCacheImpl.create();
            this._store.getConfigCache().setVersionConsistencyCache(this.vcCache);
        }
        return this.vcCache;
    }

    static {
        if (logger.isLoggable(300)) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.pmCacheBucketSize", (Object)String.valueOf(pmCacheBucketSize));
            logger.finest("sqlstore.sqlpersistencemgrfactory.pmCacheInitialCapacity", (Object)String.valueOf(pmCacheInitialCapacity));
        }
    }
}

