/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.AnnotationUtil;
import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import java.util.Objects;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.ManagedJob;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ProgressStatus;

final class CommandRunnerExecutionContext
implements CommandInvocation<AdminCommandJob> {
    private final CommandRunnerImpl commandRunner;
    private final String scope;
    private final String name;
    private final ActionReport report;
    private final Subject subject;
    private final boolean notify;
    private final boolean detach;
    private ParameterMap params;
    private CommandParameters paramObject;
    private Payload.Inbound inbound;
    private Payload.Outbound outbound;
    private ProgressStatus progressStatus;

    CommandRunnerExecutionContext(String scope, String name, ActionReport report, Subject subject, boolean notify, boolean detach, CommandRunnerImpl commandRunner) {
        this.scope = scope;
        this.name = name;
        this.report = report;
        this.subject = subject;
        this.notify = notify;
        this.detach = detach;
        this.commandRunner = commandRunner;
    }

    public CommandInvocation<AdminCommandJob> parameters(CommandParameters paramObject) {
        this.paramObject = paramObject;
        return this;
    }

    public CommandInvocation<AdminCommandJob> parameters(ParameterMap params) {
        this.params = params;
        return this;
    }

    public CommandInvocation<AdminCommandJob> inbound(Payload.Inbound inbound) {
        this.inbound = inbound;
        return this;
    }

    public CommandInvocation<AdminCommandJob> outbound(Payload.Outbound outbound) {
        this.outbound = outbound;
        return this;
    }

    public CommandInvocation<AdminCommandJob> progressStatus(ProgressStatus ps) {
        this.progressStatus = ps;
        return this;
    }

    public ParameterMap parameters() {
        return this.params == null ? new ParameterMap() : this.params;
    }

    public CommandParameters typedParams() {
        return this.paramObject;
    }

    public String getCommandName() {
        return this.name;
    }

    public ActionReport report() {
        return this.report;
    }

    public Payload.Inbound inboundPayload() {
        return this.inbound;
    }

    public Payload.Outbound outboundPayload() {
        return this.outbound;
    }

    public ProgressStatus progressStatus() {
        return this.progressStatus;
    }

    public boolean isDetached() {
        return this.detach;
    }

    public void start(AdminCommand command, AdminCommandJob job) {
        this.commandRunner.getJobManager().start(() -> this.execute(command, job));
    }

    public AdminCommandJob execute() {
        AdminCommand command = this.evaluateCommand();
        if (command == null) {
            return null;
        }
        return this.execute(command);
    }

    public AdminCommandJob execute(AdminCommand command) {
        Objects.requireNonNull(command, "AdminCommand");
        AdminCommandJob job = this.createJob(command);
        this.execute(command, job);
        return job;
    }

    public AdminCommandJob createJob(AdminCommand command) {
        boolean managedJob = this.detach || AnnotationUtil.presentTransitive(ManagedJob.class, (Class)command.getClass());
        return (AdminCommandJob)this.commandRunner.getJobManager().createJob(this.scope, this.name, this.subject, managedJob, this.params, this.report);
    }

    public AdminCommand evaluateCommand() {
        return this.commandRunner.getCommand(this.scope, this.name, this.report);
    }

    public void execute(AdminCommand command, AdminCommandJob job) {
        job.setState(AdminCommandState.State.RUNNING);
        if (job.isManaged()) {
            this.commandRunner.getJobManager().registerJob((Job)job);
        }
        this.commandRunner.doCommand(this, command, this.subject, job);
        job.complete(this.report, this.outboundPayload());
        if (this.progressStatus != null) {
            this.progressStatus.complete();
        }
        this.commandRunner.done(command, job, this.notify);
    }

    public void executeFromCheckpoint(JobManager.Checkpoint<AdminCommandJob> checkpoint, boolean revert) {
        AdminCommandJob job = (AdminCommandJob)checkpoint.getJob();
        this.parameters(job.getParameters());
        AdminCommandContext context = checkpoint.getContext();
        this.inbound = context.getInboundPayload();
        this.outbound = context.getOutboundPayload();
        job.setState(revert ? AdminCommandState.State.REVERTING : AdminCommandState.State.RUNNING_RETRYABLE);
        this.commandRunner.getJobManager().registerJob((Job)job);
        AdminCommand command = checkpoint.getCommand();
        if (command == null && (command = this.commandRunner.getCommand(job.getScope(), job.getName(), this.report)) == null) {
            return;
        }
        this.commandRunner.doCommand(this, command, this.subject, job);
        job.complete(this.report, this.outboundPayload());
        if (this.progressStatus != null) {
            this.progressStatus.complete();
        }
        this.commandRunner.done(command, job, false);
    }
}

