/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.node;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.webservices.connector.LogUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebServiceHandlerNode
extends DisplayableComponentNode<WebServiceHandler> {
    private static final Logger LOG = LogUtils.getLogger();
    private static final XMLElement TAG = new XMLElement("handler");
    private NameValuePairDescriptor initParam;

    protected XMLElement getXMLRootTag() {
        return TAG;
    }

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("soap-role", "addSoapRole");
        table.put("handler-name", "setHandlerName");
        table.put("handler-class", "setHandlerClass");
        table.put("port-name", "addPortName");
        return table;
    }

    protected WebServiceHandler createDescriptor() {
        return new WebServiceHandler();
    }

    public void setElementValue(XMLElement element, String value) {
        String qname = element.getQName();
        WebServiceHandler handler = (WebServiceHandler)this.getDescriptor();
        if ("param-name".equals(qname)) {
            this.initParam = new NameValuePairDescriptor();
            this.initParam.setName(value);
        } else if ("param-value".equals(qname)) {
            this.initParam.setValue(value);
            handler.addInitParam(this.initParam);
        } else if ("description".equals(qname)) {
            if (this.initParam != null) {
                this.initParam.setDescription(value);
                this.initParam = null;
            } else {
                super.setElementValue(element, value);
            }
        } else if ("soap-header".equals(qname)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                LOG.log(Level.SEVERE, "AS-WSCONNECTOR-00046", new Object[]{prefix, handler.getHandlerName()});
            } else {
                QName soapHeader = new QName(namespaceUri, localPart);
                handler.addSoapHeader(soapHeader);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceHandler handler) {
        Node wshNode = super.writeDescriptor(parent, nodeName, (Descriptor)handler);
        this.writeDisplayableComponentInfo(wshNode, (Descriptor)handler);
        WebServiceHandlerNode.appendTextChild((Node)wshNode, (String)"handler-name", (String)handler.getHandlerName());
        WebServiceHandlerNode.appendTextChild((Node)wshNode, (String)"handler-class", (String)handler.getHandlerClass());
        for (Object next : handler.getInitParams()) {
            Element initParamNode = WebServiceHandlerNode.appendChild((Node)wshNode, (String)"init-param");
            WebServiceHandlerNode.appendTextChild((Node)initParamNode, (String)"param-name", (String)next.getName());
            WebServiceHandlerNode.appendTextChild((Node)initParamNode, (String)"param-value", (String)next.getValue());
        }
        for (Object next : handler.getSoapHeaders()) {
            this.appendQNameChild("soap-header", wshNode, ((QName)next).getNamespaceURI(), ((QName)next).getLocalPart(), null);
        }
        for (Object next : handler.getSoapRoles()) {
            WebServiceHandlerNode.appendTextChild((Node)wshNode, (String)"soap-role", (String)next);
        }
        for (Object next : handler.getPortNames()) {
            WebServiceHandlerNode.appendTextChild((Node)wshNode, (String)"port-name", (String)next);
        }
        return wshNode;
    }

    public void writeWebServiceHandlers(Node parent, List<WebServiceHandler> handlerChain) {
        for (WebServiceHandler next : handlerChain) {
            this.writeDescriptor(parent, "handler", next);
        }
    }
}

