/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.RecordComponentInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.reflect.Field;
import java.lang.reflect.RecordComponent;
import java.util.Objects;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.DeclarationInfoImpl;
import org.jboss.weld.lite.extension.translator.FieldInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;

class RecordComponentInfoImpl
extends DeclarationInfoImpl<RecordComponent, AnnotatedMember<?>>
implements RecordComponentInfo {
    private final String className;
    private final String name;

    RecordComponentInfoImpl(RecordComponent reflectionDeclaration, BeanManager bm) {
        super(reflectionDeclaration, null, bm);
        this.className = ((RecordComponent)this.reflection).getDeclaringRecord().getName();
        this.name = ((RecordComponent)this.reflection).getName();
    }

    public String name() {
        return ((RecordComponent)this.reflection).getName();
    }

    public Type type() {
        return TypeImpl.fromReflectionType(((RecordComponent)this.reflection).getAnnotatedType(), this.bm);
    }

    public FieldInfo field() {
        try {
            Field field = ((RecordComponent)this.reflection).getDeclaringRecord().getDeclaredField(((RecordComponent)this.reflection).getName());
            return new FieldInfoImpl(field, this.bm);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public MethodInfo accessor() {
        return new MethodInfoImpl(((RecordComponent)this.reflection).getAccessor(), this.bm);
    }

    public ClassInfo declaringRecord() {
        return new ClassInfoImpl(this.bm.createAnnotatedType(((RecordComponent)this.reflection).getDeclaringRecord()), this.bm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordComponentInfoImpl)) {
            return false;
        }
        RecordComponentInfoImpl that = (RecordComponentInfoImpl)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.name);
    }
}

