/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import java.io.Console;
import java.util.logging.Level;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="login")
@PerLookup
public class LoginCommand
extends CLICommand {
    private String adminUser;
    private char[] adminPassword;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LoginCommand.class);

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        this.programOpts.setInteractive(true);
        this.adminUser = this.getAdminUser();
        this.programOpts.setUser(this.adminUser);
        this.adminPassword = "".toCharArray();
        this.programOpts.setPassword(this.adminPassword, ProgramOptions.PasswordLocation.DEFAULT);
        boolean interactive = this.programOpts.isInteractive();
        this.programOpts.setInteractive(false);
        boolean tryAgain = false;
        do {
            switch (DASUtils.pingDASWithAuth(this.programOpts, this.env)) {
                case NONE: {
                    tryAgain = false;
                    break;
                }
                case AUTHENTICATION: {
                    if (tryAgain) {
                        throw new CommandException(strings.get("InvalidCredentials", new Object[]{this.programOpts.getUser()}));
                    }
                    tryAgain = true;
                    this.programOpts.setInteractive(interactive);
                    this.adminPassword = this.getAdminPassword();
                    this.programOpts.setPassword(this.adminPassword, ProgramOptions.PasswordLocation.USER);
                    this.programOpts.setInteractive(false);
                    break;
                }
                case CONNECTION: {
                    throw new CommandException(strings.get("ConnectException", new Object[]{this.programOpts.getHost(), "" + this.programOpts.getPort()}));
                }
                case IO: {
                    throw new CommandException(strings.get("IOException", new Object[]{this.programOpts.getHost(), "" + this.programOpts.getPort()}));
                }
                case UNKNOWN: {
                    throw new CommandException(strings.get("UnknownException", new Object[]{this.programOpts.getHost(), "" + this.programOpts.getPort()}));
                }
            }
        } while (tryAgain);
        this.saveLogin(this.programOpts.getHost(), this.programOpts.getPort(), this.adminUser, this.adminPassword);
        return 0;
    }

    private String getAdminUser() {
        Console cons = System.console();
        String user = null;
        String defuser = this.programOpts.getUser();
        if (defuser == null) {
            defuser = "admin";
        }
        if (cons != null) {
            cons.printf("%s", strings.get("AdminUserPrompt", new Object[]{defuser}));
            String val = cons.readLine();
            user = val != null && val.length() > 0 ? val : defuser;
        }
        return user;
    }

    private char[] getAdminPassword() {
        String prompt = strings.get("AdminPasswordPrompt");
        return this.readPassword(prompt);
    }

    private void saveLogin(String host, int port, String user, char[] passwd) {
        if (!LoginCommand.ok(host)) {
            host = "localhost";
        }
        String sport = Integer.toString(port);
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            LoginInfo login = new LoginInfo(host, port, user, passwd);
            if (store.exists(login.getHost(), login.getPort())) {
                logger.info(strings.get("OverwriteLoginMsgCreateDomain", new Object[]{login.getHost(), "" + login.getPort()}));
            }
            store.store(login, true);
            logger.info(strings.get("LoginInfoStored", new Object[]{user, login.getHost(), sport, store.getName()}));
        }
        catch (Exception e) {
            logger.warning(strings.get("LoginInfoNotStored", new Object[]{host, sport}));
            logger.log(Level.FINER, "Could not save login!", e);
        }
    }
}

