/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authentication;

import com.sun.appserv.security.ProgrammaticLoginPermission;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.ee.web.integration.WebProgrammaticLogin;
import com.sun.logging.LogDomains;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ProgrammaticLogin {
    private WebProgrammaticLogin webProgrammaticLogin;
    private static final Logger logger = LogDomains.getLogger(ProgrammaticLogin.class, (String)"jakarta.enterprise.system.core.security");
    private static ProgrammaticLoginPermission plLogin = new ProgrammaticLoginPermission("login");
    private static ProgrammaticLoginPermission plLogout = new ProgrammaticLoginPermission("logout");
    private static final String DEFAULT_WEBPROGRAMMATICLOGIN_IMPL = "com.sun.web.security.WebProgrammaticLoginImpl";
    private static CallbackHandler handler = new LoginCallbackHandler(false);

    public ProgrammaticLogin() {
        if (SecurityServicesUtil.getInstance() != null) {
            this.resolveWebProgrammaticLogin();
        }
    }

    @Deprecated
    public Boolean login(String user, String password, String realm, boolean errors) throws Exception {
        return this.login(user, password.toCharArray(), realm, errors);
    }

    public Boolean login(final String user, final char[] password, final String realm, boolean errors) throws Exception {
        Boolean authenticated = null;
        try {
            this.checkLoginPermission(user);
            authenticated = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (SecurityServicesUtil.getInstance() != null && SecurityServicesUtil.getInstance().isServer() || Util.isEmbeddedServer()) {
                        LoginContextDriver.login((String)user, (char[])password, (String)realm);
                    } else {
                        int type = 1;
                        UsernamePasswordStore.set((String)user, (char[])password);
                        try {
                            LoginContextDriver.doClientLogin((int)type, (CallbackHandler)handler);
                        }
                        finally {
                            UsernamePasswordStore.resetThreadLocalOnly();
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "prog.login.failed", e);
            if (errors) {
                throw e;
            }
            authenticated = false;
        }
        return authenticated;
    }

    @Deprecated
    public Boolean login(String user, String password) {
        return this.login(user, password.toCharArray());
    }

    public Boolean login(String user, char[] password) {
        Boolean authenticated = null;
        try {
            authenticated = this.login(user, password, null, false);
        }
        catch (Exception e) {
            authenticated = false;
        }
        return authenticated;
    }

    @Deprecated
    public Boolean login(String user, String password, String realm, HttpServletRequest request, HttpServletResponse response, boolean errors) throws Exception {
        return this.login(user, password.toCharArray(), realm, request, response, errors);
    }

    public Boolean login(final String user, final char[] password, final String realm, final HttpServletRequest request, final HttpServletResponse response, boolean errors) throws Exception {
        Boolean authenticated = null;
        try {
            this.checkLoginPermission(user);
            authenticated = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return ProgrammaticLogin.this.webProgrammaticLogin.login(user, password, realm, request, response);
                }
            });
        }
        catch (Exception e) {
            if (errors) {
                throw e;
            }
            authenticated = false;
        }
        return authenticated;
    }

    @Deprecated
    public Boolean login(String user, String password, HttpServletRequest request, HttpServletResponse response) {
        return this.login(user, password.toCharArray(), request, response);
    }

    public Boolean login(String user, char[] password, HttpServletRequest request, HttpServletResponse response) {
        Boolean authenticated = null;
        try {
            authenticated = this.login(user, password, null, request, response, false);
        }
        catch (Exception e) {
            authenticated = false;
        }
        return authenticated;
    }

    public Boolean logout() {
        Boolean loggedout = null;
        try {
            loggedout = this.logout(false);
        }
        catch (Exception e) {
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(boolean errors) throws Exception {
        Boolean loggedout = null;
        try {
            this.checkLogoutPermission();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (SecurityServicesUtil.getInstance() != null && SecurityServicesUtil.getInstance().isServer()) {
                        LoginContextDriver.logout();
                    } else {
                        UsernamePasswordStore.reset();
                        LoginContextDriver.doClientLogout();
                    }
                    return null;
                }
            });
            loggedout = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "prog.logout.failed", e);
            if (errors) {
                throw e;
            }
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(HttpServletRequest request, HttpServletResponse response) {
        Boolean loggedout = null;
        try {
            loggedout = this.logout(request, response, false);
        }
        catch (Exception e) {
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(final HttpServletRequest request, final HttpServletResponse response, boolean errors) throws Exception {
        Boolean loggedout = null;
        try {
            this.checkLogoutPermission();
            loggedout = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return ProgrammaticLogin.this.webProgrammaticLogin.logout(request, response);
                }
            });
        }
        catch (Exception e) {
            if (errors) {
                throw e;
            }
            loggedout = false;
        }
        return loggedout;
    }

    private void checkLoginPermission(String user) throws Exception {
        try {
            SecurityManager sm;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ProgrammaticLogin.login() called for user: " + user);
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission((Permission)plLogin);
            }
        }
        catch (Exception e) {
            logger.warning("proglogin.noperm");
            throw e;
        }
    }

    private void checkLogoutPermission() throws Exception {
        try {
            SecurityManager sm;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ProgrammaticLogin.logout() called.");
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission((Permission)plLogout);
            }
        }
        catch (Exception e) {
            logger.warning("prologout.noperm");
            throw e;
        }
    }

    private void resolveWebProgrammaticLogin() {
        ServiceLocator habitat = SecurityServicesUtil.getInstance().getHabitat();
        this.webProgrammaticLogin = (WebProgrammaticLogin)habitat.getService(WebProgrammaticLogin.class, new Annotation[0]);
    }
}

