/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.CheckContext;
import org.glassfish.rmic.tools.tree.CodeContext;
import org.glassfish.rmic.tools.tree.ConditionVars;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.ExpressionStatement;
import org.glassfish.rmic.tools.tree.NotExpression;
import org.glassfish.rmic.tools.tree.Statement;
import org.glassfish.rmic.tools.tree.Vset;

public class IfStatement
extends Statement {
    Expression cond;
    Statement ifTrue;
    Statement ifFalse;

    public IfStatement(long where, Expression cond, Statement ifTrue, Statement ifFalse) {
        super(90, where);
        this.cond = cond;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.checkLabel(env, ctx);
        CheckContext newctx = new CheckContext(ctx, this);
        ConditionVars cvars = this.cond.checkCondition(env, newctx, this.reach(env, vset), exp);
        this.cond = this.convert(env, newctx, Type.tBoolean, this.cond);
        Vset vsTrue = cvars.vsTrue.clearDeadEnd();
        Vset vsFalse = cvars.vsFalse.clearDeadEnd();
        vsTrue = this.ifTrue.check(env, newctx, vsTrue, exp);
        if (this.ifFalse != null) {
            vsFalse = this.ifFalse.check(env, newctx, vsFalse, exp);
        }
        vset = vsTrue.join(vsFalse.join(newctx.vsBreak));
        return ctx.removeAdditionalVars(vset);
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        ctx = new Context(ctx, this);
        this.cond = this.cond.inlineValue(env, ctx);
        if (this.ifTrue != null) {
            this.ifTrue = this.ifTrue.inline(env, ctx);
        }
        if (this.ifFalse != null) {
            this.ifFalse = this.ifFalse.inline(env, ctx);
        }
        if (this.cond.equals(true)) {
            return this.eliminate(env, this.ifTrue);
        }
        if (this.cond.equals(false)) {
            return this.eliminate(env, this.ifFalse);
        }
        if (this.ifTrue == null && this.ifFalse == null) {
            return this.eliminate(env, new ExpressionStatement(this.where, this.cond).inline(env, ctx));
        }
        if (this.ifTrue == null) {
            this.cond = new NotExpression(this.cond.where, this.cond).inlineValue(env, ctx);
            return this.eliminate(env, new IfStatement(this.where, this.cond, this.ifFalse, null));
        }
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        IfStatement s = (IfStatement)this.clone();
        s.cond = this.cond.copyInline(ctx);
        if (this.ifTrue != null) {
            s.ifTrue = this.ifTrue.copyInline(ctx, valNeeded);
        }
        if (this.ifFalse != null) {
            s.ifFalse = this.ifFalse.copyInline(ctx, valNeeded);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = 1 + this.cond.costInline(thresh, env, ctx);
        if (this.ifTrue != null) {
            cost += this.ifTrue.costInline(thresh, env, ctx);
        }
        if (this.ifFalse != null) {
            cost += this.ifFalse.costInline(thresh, env, ctx);
        }
        return cost;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        CodeContext newctx = new CodeContext(ctx, this);
        Label l1 = new Label();
        this.cond.codeBranch(env, newctx, asm, l1, false);
        this.ifTrue.code(env, newctx, asm);
        if (this.ifFalse != null) {
            Label l2 = new Label();
            asm.add(true, this.where, 167, l2);
            asm.add(l1);
            this.ifFalse.code(env, newctx, asm);
            asm.add(l2);
        } else {
            asm.add(l1);
        }
        asm.add(newctx.breakLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("if ");
        this.cond.print(out);
        out.print(" ");
        this.ifTrue.print(out, indent);
        if (this.ifFalse != null) {
            out.print(" else ");
            this.ifFalse.print(out, indent);
        }
    }
}

