/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import jakarta.ejb.AccessTimeout;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=AccessTimeout.class)
public class AccessTimeoutHandler
extends AbstractAttributeHandler
implements PostProcessor<EjbContext> {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        AccessTimeout timeout = (AccessTimeout)ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            EjbSessionDescriptor sessionDesc;
            if (!(ejbContext.getDescriptor() instanceof EjbSessionDescriptor) || (sessionDesc = (EjbSessionDescriptor)ejbContext.getDescriptor()).isStateless()) continue;
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, (PostProcessor)this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            if (this.matchesExistingAccessTimeoutMethod(annMethod, sessionDesc)) continue;
            MethodDescriptor newMethodDesc = new MethodDescriptor(annMethod);
            sessionDesc.addAccessTimeoutMethod(newMethodDesc, timeout.value(), timeout.unit());
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Singleton.class, Stateful.class, ConcurrencyManagement.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    public void postProcessAnnotation(AnnotationInfo ainfo, EjbContext ejbContext) throws AnnotationProcessorException {
        EjbSessionDescriptor ejbDesc = (EjbSessionDescriptor)ejbContext.getDescriptor();
        Class classAn = (Class)ainfo.getAnnotatedElement();
        AccessTimeout timeoutAnn = (AccessTimeout)ainfo.getAnnotation();
        ArrayList<Method> toProcess = new ArrayList<Method>();
        for (Method m : ejbContext.getComponentDefinitionMethods()) {
            if (!classAn.equals(m.getDeclaringClass())) continue;
            toProcess.add(m);
        }
        for (Method m : classAn.getDeclaredMethods()) {
            if (!Modifier.isPrivate(m.getModifiers())) continue;
            toProcess.add(m);
        }
        for (Method m : toProcess) {
            if (this.matchesExistingAccessTimeoutMethod(m, ejbDesc)) continue;
            MethodDescriptor newMethodDesc = new MethodDescriptor(m);
            ejbDesc.addAccessTimeoutMethod(newMethodDesc, timeoutAnn.value(), timeoutAnn.unit());
        }
    }

    private boolean matchesExistingAccessTimeoutMethod(Method methodToMatch, EjbSessionDescriptor desc) {
        List<MethodDescriptor> timeoutMethods = desc.getAccessTimeoutMethods();
        boolean match = false;
        for (MethodDescriptor next : timeoutMethods) {
            Method m = next.getMethod((EjbDescriptor)desc);
            if (!m.getDeclaringClass().equals(methodToMatch.getDeclaringClass()) || !TypeUtil.sameMethodSignature((Method)m, (Method)methodToMatch)) continue;
            match = true;
            break;
        }
        return match;
    }
}

