/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm.internal;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.exceptions.ValidationException;

public class Util {
    public static Object getFieldValue(Map<String, String> targetNames, String name, Class<?> type) {
        String asmService = ASMFactory.getAsmService();
        Object result = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            String className = targetNames.get(asmService);
            if (className == null) {
                throw ValidationException.incorrectASMServiceProvided();
            }
            Class<?> clazz = lookup.findClass(className);
            VarHandle field = lookup.findStaticVarHandle(clazz, name, type);
            result = field.get();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw ValidationException.notAvailableASMService();
        }
        return result;
    }
}

