/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.config.LbConfig;
import org.glassfish.loadbalancer.config.LbConfigs;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-health-checker")
@PerLookup
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="delete-http-health-checker", description="delete-http-health-checker", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="delete-http-health-checker", description="delete-http-health-checker", params={@RestParam(name="target", value="$parent")})})
public final class DeleteHTTPHealthCheckerCommand
implements AdminCommand {
    @Param(optional=true)
    String config;
    @Param(primary=true)
    String target;
    @Inject
    Domain domain;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteHTTPHealthCheckerCommand.class);

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        LbConfigs lbconfigs = (LbConfigs)this.domain.getExtensionByType(LbConfigs.class);
        if (lbconfigs == null) {
            String msg = localStrings.getLocalString("NoLbConfigsElement", "Empty lb-configs");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (this.config != null) {
            LbConfig lbConfig = lbconfigs.getLbConfig(this.config);
            this.deleteHealthCheckerInternal(lbConfig, this.target, false);
        } else {
            List lbConfigs = lbconfigs.getLbConfig();
            if (lbConfigs.isEmpty()) {
                String msg = localStrings.getLocalString("NoLbConfigsElement", "Empty lb-configs");
                this.logger.warning(msg);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            for (LbConfig lc : lbConfigs) {
                this.deleteHealthCheckerInternal(lc, this.target, true);
            }
        }
    }

    private void deleteHealthCheckerInternal(LbConfig lbConfig, String target, boolean ignoreFailure) {
        if (lbConfig == null) {
            String msg = localStrings.getLocalString("InvalidLbConfigName", "Invalid LB configuration.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        String lbConfigName = lbConfig.getName();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("[LB-ADMIN] deleteHealthChecker called - LB Config Name: " + lbConfigName + ", Target: " + target);
        }
        if (target == null) {
            String msg = localStrings.getLocalString("Nulltarget", "Null target");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (this.tgt.isCluster(target)) {
            ClusterRef cRef = (ClusterRef)lbConfig.getRefByRef(ClusterRef.class, target);
            if (cRef == null && !ignoreFailure) {
                String msg = localStrings.getLocalString("UnassociatedCluster", "Load balancer configuration [{0}] does not have a reference to the given cluster [{1}].", new Object[]{lbConfigName, target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            if (cRef != null) {
                HealthChecker hc = cRef.getHealthChecker();
                if (hc != null) {
                    this.removeHealthCheckerFromClusterRef(cRef);
                    String msg = localStrings.getLocalString("http_lb_admin.HealthCheckerDeleted", "Health checker deleted for target {0}", new Object[]{target});
                    this.logger.info(msg);
                } else if (!ignoreFailure) {
                    String msg = localStrings.getLocalString("HealthCheckerDoesNotExist", "Health checker does not exist for target {0} in LB {1}", new Object[]{target, lbConfigName});
                    this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    this.report.setMessage(msg);
                    return;
                }
            }
        } else if (this.domain.isServer(target)) {
            ServerRef sRef = (ServerRef)lbConfig.getRefByRef(ServerRef.class, target);
            if (sRef == null && !ignoreFailure) {
                String msg = localStrings.getLocalString("UnassociatedServer", "Load balancer configuration [{0}] does not have a reference to the given server [{1}].", new Object[]{lbConfigName, target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            if (sRef != null) {
                HealthChecker hc = sRef.getHealthChecker();
                if (hc != null) {
                    this.removeHealthCheckerFromServerRef(sRef);
                    String msg = localStrings.getLocalString("http_lb_admin.HealthCheckerDeleted", "Health checker deleted for target {0}", new Object[]{target});
                    this.logger.info(msg);
                } else if (!ignoreFailure) {
                    String msg = localStrings.getLocalString("HealthCheckerDoesNotExist", "Health checker does not exist for target {0} in LB {1}", new Object[]{target, lbConfigName});
                    this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    this.report.setMessage(msg);
                    return;
                }
            }
        } else {
            String msg = localStrings.getLocalString("InvalidTarget", "Invalid target", new Object[]{target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
    }

    private void removeHealthCheckerFromClusterRef(ClusterRef cRef) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ClusterRef>(){

                public Object run(ClusterRef param) throws PropertyVetoException, TransactionFailure {
                    param.setHealthChecker(null);
                    return Boolean.TRUE;
                }
            }, (ConfigBeanProxy)cRef);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToRemoveHC", "Failed to remove health-checker");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause((Throwable)ex);
            return;
        }
    }

    private void removeHealthCheckerFromServerRef(ServerRef sRef) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ServerRef>(){

                public Object run(ServerRef param) throws PropertyVetoException, TransactionFailure {
                    param.setHealthChecker(null);
                    return Boolean.TRUE;
                }
            }, (ConfigBeanProxy)sRef);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToRemoveHC", "Failed to remove health-checker");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause((Throwable)ex);
            return;
        }
    }
}

