/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.hk2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.MethodParameter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorState;
import org.glassfish.hk2.api.Unqualified;

public class CombiningServiceLocator
implements ServiceLocator {
    private static final System.Logger LOG = System.getLogger(CombiningServiceLocator.class.getName());
    private final ServiceLocator primaryLocator;
    private final ServiceLocator fallbackLocator;

    public CombiningServiceLocator(ServiceLocator primaryLocator, ServiceLocator fallbackLocator) {
        this.primaryLocator = primaryLocator;
        this.fallbackLocator = fallbackLocator;
    }

    public <T> T getService(Class<T> contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return (T)this.getCombinedService(locator -> locator.getService(contractOrImpl, qualifiers));
    }

    private <T> T getCombinedService(Function<ServiceLocator, T> selector) {
        try {
            return selector.apply(this.primaryLocator);
        }
        catch (MultiException e) {
            return selector.apply(this.fallbackLocator);
        }
    }

    public <T> T getService(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return (T)this.getCombinedService(locator -> locator.getService(contractOrImpl, qualifiers));
    }

    public <T> T getService(Class<T> contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        return (T)this.getCombinedService(locator -> locator.getService(contractOrImpl, name, qualifiers));
    }

    public <T> T getService(Type contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        return (T)this.getCombinedService(locator -> locator.getService(contractOrImpl, name, qualifiers));
    }

    public <T> T getService(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) throws MultiException {
        return (T)this.getCombinedService(locator -> locator.getService(activeDescriptor, root));
    }

    public <T> T getService(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root, Injectee injectee) throws MultiException {
        return (T)this.getCombinedService(locator -> locator.getService(activeDescriptor, root, injectee));
    }

    public <T> List<T> getAllServices(Class<T> contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return this.getCombinedServicesWithType(locator -> locator.getAllServiceHandles(contractOrImpl, qualifiers));
    }

    private <T> List<T> getCombinedServicesWithType(Function<ServiceLocator, List<ServiceHandle<T>>> selector) {
        return this.getCombinedServices(locator -> (List)selector.apply((ServiceLocator)locator));
    }

    private List<?> getCombinedServices(Function<ServiceLocator, List<ServiceHandle<?>>> selector) {
        List<ServiceHandle<?>> allServicesFromPrimary;
        try {
            allServicesFromPrimary = selector.apply(this.primaryLocator);
        }
        catch (MultiException e) {
            allServicesFromPrimary = List.of();
        }
        List<ServiceHandle<?>> allServicesFromFallback = selector.apply(this.fallbackLocator);
        return this.unionOfLists(allServicesFromPrimary, allServicesFromFallback);
    }

    private List<?> unionOfLists(List<ServiceHandle<?>> primaryList, List<ServiceHandle<?>> fallbackList) {
        HashSet<List<Long>> serviceKeysInResult = new HashSet<List<Long>>();
        ArrayList<Object> result = new ArrayList<Object>();
        Iterable iterableOverBothLists = () -> Stream.concat(primaryList.stream(), fallbackList.stream()).iterator();
        for (ServiceHandle serviceHandle : iterableOverBothLists) {
            Long locatorId;
            Type serviceType = serviceHandle.getActiveDescriptor().getImplementationType();
            List<Long> serviceKey = List.of(serviceType, locatorId = serviceHandle.getActiveDescriptor().getLocatorId());
            if (serviceKeysInResult.contains(serviceKey)) continue;
            try {
                Object service = serviceHandle.getService();
                serviceKeysInResult.add(serviceKey);
                result.add(service);
            }
            catch (MultiException e) {
                LOG.log(System.Logger.Level.DEBUG, () -> "Error getting " + String.valueOf(serviceHandle.getActiveDescriptor().getImplementationType()) + " from service locator id=" + serviceHandle.getActiveDescriptor().getLocatorId() + " (primaryLocator id=" + this.primaryLocator.getLocatorId() + ", fallbackLocator id=" + this.fallbackLocator.getLocatorId() + "). " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public <T> List<T> getAllServices(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return this.getCombinedServices(locator -> locator.getAllServiceHandles(contractOrImpl, qualifiers));
    }

    public <T> List<T> getAllServices(Annotation qualifier, Annotation ... qualifiers) throws MultiException {
        return this.getCombinedServices(locator -> locator.getAllServiceHandles(qualifier, qualifiers));
    }

    public List<?> getAllServices(Filter searchCriteria) throws MultiException {
        return this.getCombinedServices(locator -> locator.getAllServiceHandles(searchCriteria));
    }

    public <T> ServiceHandle<T> getServiceHandle(Class<T> contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return this.primaryLocator.getServiceHandle(contractOrImpl, qualifiers);
    }

    public <T> ServiceHandle<T> getServiceHandle(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return this.primaryLocator.getServiceHandle(contractOrImpl, qualifiers);
    }

    public <T> ServiceHandle<T> getServiceHandle(Class<T> contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        return this.primaryLocator.getServiceHandle(contractOrImpl, name, qualifiers);
    }

    public <T> ServiceHandle<T> getServiceHandle(Type contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        return this.primaryLocator.getServiceHandle(contractOrImpl, name, qualifiers);
    }

    public <T> List<ServiceHandle<T>> getAllServiceHandles(Class<T> contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return this.primaryLocator.getAllServiceHandles(contractOrImpl, qualifiers);
    }

    public List<ServiceHandle<?>> getAllServiceHandles(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return this.primaryLocator.getAllServiceHandles(contractOrImpl, qualifiers);
    }

    public List<ServiceHandle<?>> getAllServiceHandles(Annotation qualifier, Annotation ... qualifiers) throws MultiException {
        return this.primaryLocator.getAllServiceHandles(qualifier, qualifiers);
    }

    public List<ServiceHandle<?>> getAllServiceHandles(Filter searchCriteria) throws MultiException {
        return this.primaryLocator.getAllServiceHandles(searchCriteria);
    }

    public List<ActiveDescriptor<?>> getDescriptors(Filter filter) {
        return this.primaryLocator.getDescriptors(filter);
    }

    public ActiveDescriptor<?> getBestDescriptor(Filter filter) {
        return this.primaryLocator.getBestDescriptor(filter);
    }

    public ActiveDescriptor<?> reifyDescriptor(Descriptor descriptor, Injectee injectee) throws MultiException {
        return this.primaryLocator.reifyDescriptor(descriptor, injectee);
    }

    public ActiveDescriptor<?> reifyDescriptor(Descriptor descriptor) throws MultiException {
        return this.primaryLocator.reifyDescriptor(descriptor);
    }

    public ActiveDescriptor<?> getInjecteeDescriptor(Injectee injectee) throws MultiException {
        return this.primaryLocator.getInjecteeDescriptor(injectee);
    }

    public <T> ServiceHandle<T> getServiceHandle(ActiveDescriptor<T> activeDescriptor, Injectee injectee) throws MultiException {
        return this.primaryLocator.getServiceHandle(activeDescriptor, injectee);
    }

    public <T> ServiceHandle<T> getServiceHandle(ActiveDescriptor<T> activeDescriptor) throws MultiException {
        return this.primaryLocator.getServiceHandle(activeDescriptor);
    }

    public String getDefaultClassAnalyzerName() {
        return this.primaryLocator.getDefaultClassAnalyzerName();
    }

    public void setDefaultClassAnalyzerName(String defaultClassAnalyzer) {
        this.primaryLocator.setDefaultClassAnalyzerName(defaultClassAnalyzer);
    }

    public Unqualified getDefaultUnqualified() {
        return this.primaryLocator.getDefaultUnqualified();
    }

    public void setDefaultUnqualified(Unqualified unqualified) {
        this.primaryLocator.setDefaultUnqualified(unqualified);
    }

    public String getName() {
        return this.primaryLocator.getName();
    }

    public long getLocatorId() {
        return this.primaryLocator.getLocatorId();
    }

    public ServiceLocator getParent() {
        return this.primaryLocator.getParent();
    }

    public void shutdown() {
        this.primaryLocator.shutdown();
    }

    public ServiceLocatorState getState() {
        return this.primaryLocator.getState();
    }

    public boolean isShutdown() {
        return this.primaryLocator.isShutdown();
    }

    public boolean getNeutralContextClassLoader() {
        return this.primaryLocator.getNeutralContextClassLoader();
    }

    public void setNeutralContextClassLoader(boolean neutralContextClassLoader) {
        this.primaryLocator.setNeutralContextClassLoader(neutralContextClassLoader);
    }

    public <T> T create(Class<T> createMe) {
        return (T)this.primaryLocator.create(createMe);
    }

    public <T> T create(Class<T> createMe, String strategy) {
        return (T)this.primaryLocator.create(createMe, strategy);
    }

    public void inject(Object injectMe) {
        this.primaryLocator.inject(injectMe);
    }

    public void inject(Object injectMe, String strategy) {
        this.primaryLocator.inject(injectMe, strategy);
    }

    public Object assistedInject(Object injectMe, Method method, MethodParameter ... params) {
        return this.primaryLocator.assistedInject(injectMe, method, params);
    }

    public Object assistedInject(Object injectMe, Method method, ServiceHandle<?> root, MethodParameter ... params) {
        return this.primaryLocator.assistedInject(injectMe, method, root, params);
    }

    public void postConstruct(Object postConstructMe) {
        this.primaryLocator.postConstruct(postConstructMe);
    }

    public void postConstruct(Object postConstructMe, String strategy) {
        this.primaryLocator.postConstruct(postConstructMe, strategy);
    }

    public void preDestroy(Object preDestroyMe) {
        this.primaryLocator.preDestroy(preDestroyMe);
    }

    public void preDestroy(Object preDestroyMe, String strategy) {
        this.primaryLocator.preDestroy(preDestroyMe, strategy);
    }

    public <U> U createAndInitialize(Class<U> createMe) {
        return (U)this.primaryLocator.createAndInitialize(createMe);
    }

    public <U> U createAndInitialize(Class<U> createMe, String strategy) {
        return (U)this.primaryLocator.createAndInitialize(createMe, strategy);
    }
}

