/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.connector.module;

import com.sun.enterprise.connectors.connector.module.ConnectorSniffer;
import com.sun.enterprise.connectors.connector.module.RarType;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.resource.spi.Connector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="rar")
@Singleton
public class RarDetector
implements ArchiveDetector {
    private static final Class<?>[] connectorAnnotations = new Class[]{Connector.class};
    private static final String RAR_DETECTOR_RANK_PROP = "glassfish.rar.detector.rank";
    private static final int DEFAULT_RAR_DETECTOR_RANK = 300;
    @Inject
    private RarType archiveType;
    @Inject
    private ConnectorSniffer sniffer;
    @Inject
    private ServiceLocator services;
    private ArchiveHandler archiveHandler;
    private static final Logger LOG = Logger.getLogger(RarDetector.class.getName());
    private static final String RA_XML = "META-INF/ra.xml";
    private static final String RAR_EXTENSION = ".rar";

    public int rank() {
        return Integer.getInteger(RAR_DETECTOR_RANK_PROP, 300);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveHandler getArchiveHandler() {
        RarDetector rarDetector = this;
        synchronized (rarDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, LOG);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = (ArchiveHandler)this.services.getService(ArchiveHandler.class, "rar", new Annotation[0]);
            }
            return this.archiveHandler;
        }
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        boolean handles = false;
        try {
            if (Util.getURIName((URI)archive.getURI()).endsWith(RAR_EXTENSION)) {
                return true;
            }
            handles = archive.exists(RA_XML);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!handles && archive instanceof FileArchive) {
            GenericAnnotationDetector detector = new GenericAnnotationDetector((Class[])connectorAnnotations);
            handles = detector.hasAnnotationInArchive(archive);
        }
        return handles;
    }
}

