/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.nosql.metadata.reflection;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jnosql.mapping.metadata.ConstructorMetadata;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;
import org.glassfish.main.jnosql.nosql.metadata.reflection.DefaultConstructorMetadata;
import org.glassfish.main.jnosql.nosql.metadata.reflection.ParameterMetaDataBuilder;
import org.glassfish.main.jnosql.nosql.metadata.reflection.Reflections;

final class ConstructorMetadataBuilder {
    private final Reflections reflections;

    ConstructorMetadataBuilder(Reflections reflections) {
        this.reflections = reflections;
    }

    <T> ConstructorMetadata build(Class<T> entity) {
        Constructor<T> constructor = Reflections.getConstructor(entity);
        if (constructor.getParameterCount() == 0) {
            return new DefaultConstructorMetadata(constructor, Collections.emptyList());
        }
        List<ParameterMetaData> parameters = Stream.of(constructor.getParameters()).map(ParameterMetaDataBuilder::of).toList();
        return new DefaultConstructorMetadata(constructor, parameters);
    }
}

