/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ApplicationRegistry {
    @Inject
    Provider<Deployment> deploymentServiceProvider;
    @Inject
    Provider<InvocationManager> invocationManagerProvider;
    private Map<String, ApplicationInfo> deployedApplications = new HashMap<String, ApplicationInfo>();

    public synchronized void add(String name, ApplicationInfo info) {
        this.deployedApplications.put(name, info);
    }

    public ApplicationInfo get(String name) {
        return this.deployedApplications.get(name);
    }

    public synchronized void remove(String name) {
        this.deployedApplications.remove(name);
    }

    public Set<String> getAllApplicationNames() {
        return this.deployedApplications.keySet();
    }

    public Optional<ApplicationInfo> getCurrentApplicationInfo() {
        Deployment deploymentService = (Deployment)this.deploymentServiceProvider.get();
        DeploymentContext deploymentContext = deploymentService.getCurrentDeploymentContext();
        if (deploymentContext != null) {
            return Optional.ofNullable((ApplicationInfo)deploymentContext.getModuleMetaData(ApplicationInfo.class));
        }
        ComponentInvocation currentInvocation = ((InvocationManager)this.invocationManagerProvider.get()).getCurrentInvocation();
        String applicationName = null;
        if (currentInvocation != null && null != (applicationName = currentInvocation.getAppName())) {
            return Optional.ofNullable(this.get(applicationName));
        }
        return Optional.empty();
    }
}

