/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.queries.ComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;

public abstract class ORMetadata {
    private MetadataAnnotation m_annotation;
    private MetadataAccessibleObject m_accessibleObject;
    private Object m_location;
    protected MetadataProject m_project;
    private XMLEntityMappings m_entityMappings;
    private String m_xmlElement;
    private static final Map<String, Class<?>> primitiveClasses = Collections.unmodifiableMap(ORMetadata.getPrimitiveClassesMap());
    private static final Map<String, String> boxedTypes = Collections.unmodifiableMap(ORMetadata.getBoxedTypesMap());

    protected ORMetadata() {
    }

    public ORMetadata(String xmlElement) {
        this.m_xmlElement = xmlElement;
    }

    public abstract boolean equals(Object var1);

    protected ORMetadata(MetadataAccessibleObject accessibleObject, MetadataProject project, Object location) {
        this.m_location = location;
        this.m_accessibleObject = accessibleObject;
        this.m_project = project;
    }

    public ORMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        this(accessor.getAccessibleObject(), accessor.getProject(), accessor.getLocation());
        this.m_annotation = annotation;
    }

    public ORMetadata(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, MetadataProject project) {
        this(accessibleObject, project, accessibleObject);
        this.m_annotation = annotation;
    }

    public ORMetadata(ORMetadata orm) {
        this.m_location = orm.getLocation();
        this.m_accessibleObject = orm.getAccessibleObject();
        this.m_project = orm.getProject();
        this.m_annotation = orm.getAnnotation();
    }

    protected MetadataAccessibleObject getAccessibleObject() {
        return this.m_accessibleObject;
    }

    public String getAccessibleObjectName() {
        return this.m_accessibleObject.getName();
    }

    public MetadataAnnotation getAnnotation() {
        return this.m_annotation;
    }

    protected String getBoxedType(String type) {
        String value = boxedTypes.get(type);
        return value != null ? value : type;
    }

    public ClassLoader getLoader() {
        return this.getMetadataFactory().getLoader();
    }

    protected DatabaseType getDatabaseTypeEnum(String type) {
        if (type == null) {
            return JDBCTypes.VARCHAR_TYPE;
        }
        try {
            return JDBCTypes.valueOf((String)type);
        }
        catch (Exception invalid) {
            try {
                return OraclePLSQLTypes.valueOf((String)type);
            }
            catch (Exception alsoInvalid) {
                ComplexTypeMetadata typeMetadata = this.getProject().getComplexTypeMetadata(type);
                if (typeMetadata != null) {
                    return typeMetadata.process();
                }
                PLSQLrecord record = new PLSQLrecord();
                record.setTypeName(type);
                return record;
            }
        }
    }

    public XMLEntityMappings getEntityMappings() {
        return this.m_entityMappings;
    }

    protected String getFullyQualifiedClassName(String className) {
        Class<?> primitiveClass = this.getPrimitiveClassForName(className);
        if (primitiveClass == null) {
            if (this.loadedFromXML()) {
                return this.getEntityMappings().getPackageQualifiedClassName(className);
            }
            return className;
        }
        return primitiveClass.getName();
    }

    protected String getIdentifier() {
        return "";
    }

    protected Class<?> getJavaClass(MetadataClass metadataClass) {
        String className = metadataClass.getName();
        Class<?> primitiveClass = this.getPrimitiveClassForName(className);
        if (primitiveClass == null) {
            Object convertedClassName = className;
            int index = className.indexOf(91);
            if (index > 0 && className.charAt(index + 1) == ']') {
                convertedClassName = "[L" + className.substring(0, index) + ";";
            }
            convertedClassName = this.getFullyQualifiedClassName((String)convertedClassName);
            return MetadataHelper.getClassForName((String)convertedClassName, this.getLoader());
        }
        return primitiveClass;
    }

    public String getJavaClassName(MetadataClass metadataClass) {
        String className = metadataClass.getName();
        Class<?> primitiveClass = this.getPrimitiveClassForName(className);
        if (primitiveClass == null) {
            Object convertedClassName = className;
            int index = className.indexOf(91);
            if (index > 0 && className.charAt(index + 1) == ']') {
                convertedClassName = "[L" + className.substring(0, index) + ";";
            }
            return this.getFullyQualifiedClassName((String)convertedClassName);
        }
        return primitiveClass.getName();
    }

    public Object getLocation() {
        return this.m_location;
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public MetadataClass getMetadataClass(Class<?> javaClass) {
        if (javaClass == null) {
            return null;
        }
        return this.getMetadataClass(javaClass.getName());
    }

    public MetadataClass getMetadataClass(String className) {
        return this.getMetadataClass(className, true);
    }

    public MetadataClass getMetadataClass(String className, boolean isLazy) {
        return this.getMetadataFactory().getMetadataClass(this.getFullyQualifiedClassName(className), isLazy);
    }

    public MetadataFactory getMetadataFactory() {
        if (this.getAccessibleObject() != null) {
            return this.getAccessibleObject().getMetadataFactory();
        }
        return this.getEntityMappings().getMetadataFactory();
    }

    protected String getName(String name, String defaultName, String context) {
        return MetadataHelper.getName(name, defaultName, context, this.getLogger(), this.getAccessibleObjectName());
    }

    protected Class<?> getPrimitiveClassForName(String className) {
        return className == null ? Void.TYPE : primitiveClasses.get(className);
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    protected String getText() {
        return null;
    }

    protected String getXMLElement() {
        return this.m_xmlElement;
    }

    protected boolean hasIdentifier() {
        return this.getIdentifier() != null && !this.getIdentifier().isEmpty();
    }

    protected boolean hasText() {
        return this.getText() != null && !this.getText().isEmpty();
    }

    protected MetadataClass initXMLClassName(String className) {
        return this.getMetadataClass(className);
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        this.m_project = entityMappings.getProject();
        this.m_accessibleObject = accessibleObject;
        this.setEntityMappings(entityMappings);
    }

    protected void initXMLObject(ORMetadata metadata, MetadataAccessibleObject accessibleObject) {
        if (metadata != null) {
            metadata.initXMLObject(accessibleObject, this.m_entityMappings);
        }
    }

    protected <T extends ORMetadata> void initXMLObjects(List<T> metadatas, MetadataAccessibleObject accessibleObject) {
        if (metadatas != null) {
            for (ORMetadata metadata : metadatas) {
                metadata.initXMLObject(accessibleObject, this.m_entityMappings);
            }
        }
    }

    protected <T extends ORMetadata> String initXMLTextObject(List<T> metadatas) {
        ORMetadata metadata;
        if (metadatas != null && metadatas.size() == 1 && (metadata = (ORMetadata)metadatas.get(0)).hasText()) {
            String text = metadata.getText();
            metadatas = null;
            return text;
        }
        return null;
    }

    public boolean loadedFromAnnotation() {
        return this.m_annotation != null || !this.loadedFromXML();
    }

    public boolean loadedFromEclipseLinkXML() {
        if (this.loadedFromXML()) {
            return this.m_entityMappings.isEclipseLinkORMFile();
        }
        return false;
    }

    public boolean loadedFromXML() {
        return this.m_entityMappings != null;
    }

    protected void merge(ORMetadata metadata) {
    }

    protected <T extends ORMetadata> List<T> mergeORObjectLists(List<T> list1, List<T> list2) {
        boolean found;
        ArrayList<ORMetadata> newList = new ArrayList<ORMetadata>();
        for (ORMetadata obj1 : list1) {
            found = false;
            for (ORMetadata obj2 : list2) {
                if (!obj2.getIdentifier().equals(obj1.getIdentifier())) continue;
                if (obj2.shouldOverride(obj1)) {
                    newList.add(obj2);
                } else {
                    newList.add(obj1);
                }
                found = true;
                break;
            }
            if (found) continue;
            newList.add(obj1);
        }
        for (ORMetadata obj2 : list2) {
            found = false;
            for (ORMetadata obj1 : list1) {
                if (!obj2.getIdentifier().equals(obj1.getIdentifier())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newList.add(obj2);
        }
        return newList;
    }

    protected ORMetadata mergeORObjects(ORMetadata obj1, ORMetadata obj2) {
        if (obj2 != null) {
            if (obj1 != null) {
                if (obj2.shouldOverride(obj1)) {
                    return obj2;
                }
            } else {
                return obj2;
            }
        }
        return obj1;
    }

    protected Object mergeSimpleObjects(Object obj1, Object obj2, ORMetadata otherMetadata, String xmlElement) {
        if (obj1 == null && obj2 == null) {
            return null;
        }
        SimpleORMetadata object1 = obj1 == null ? null : new SimpleORMetadata(obj1, this.getAccessibleObject(), this.getEntityMappings(), xmlElement);
        SimpleORMetadata object2 = obj2 == null ? null : new SimpleORMetadata(obj2, otherMetadata.getAccessibleObject(), otherMetadata.getEntityMappings(), xmlElement);
        return ((SimpleORMetadata)this.mergeORObjects(object1, object2)).getValue();
    }

    protected EntityAccessor reloadEntity(EntityAccessor entity, MetadataDescriptor descriptor) {
        if (entity.loadedFromAnnotation()) {
            EntityAccessor entityAccessor = new EntityAccessor(entity.getAnnotation(), entity.getJavaClass(), entity.getProject());
            descriptor.setDefaultAccess(entity.getDescriptor().getDefaultAccess());
            entityAccessor.setDescriptor(descriptor);
            return entityAccessor;
        }
        return entity.getEntityMappings().reloadEntity(entity, descriptor);
    }

    protected MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor mappedSuperclass, MetadataDescriptor descriptor) {
        if (mappedSuperclass.loadedFromAnnotation()) {
            MappedSuperclassAccessor mappedSuperclassAccessor = new MappedSuperclassAccessor(mappedSuperclass.getAnnotation(), mappedSuperclass.getJavaClass(), descriptor);
            return mappedSuperclassAccessor;
        }
        return mappedSuperclass.getEntityMappings().reloadMappedSuperclass(mappedSuperclass, descriptor);
    }

    public void setAccessibleObject(MetadataAccessibleObject accessibleObject) {
        this.m_accessibleObject = accessibleObject;
    }

    public void setEntityMappings(XMLEntityMappings entityMappings) {
        this.m_entityMappings = entityMappings;
        this.m_location = entityMappings.getMappingFileOrURL();
    }

    protected void setFieldName(DatabaseField field, String name) {
        field.setName(name, Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
        if (this.m_project.useDelimitedIdentifier()) {
            field.setUseDelimiters(true);
        } else if (this.m_project.getShouldForceFieldNamesToUpperCase() && !field.shouldUseDelimiters()) {
            field.useUpperCaseForComparisons(true);
        }
    }

    protected void setFieldName(DatabaseField field, String defaultName, String context) {
        this.setFieldName(field, this.getName(field.getName(), defaultName, context));
    }

    public void setProject(MetadataProject project) {
        this.m_project = project;
    }

    public boolean shouldOverride(ORMetadata existing) {
        MetadataLogger logger = this.getAccessibleObject().getLogger();
        if (existing == null) {
            return true;
        }
        if (!existing.equals(this)) {
            if (this.loadedFromXML() && existing.loadedFromAnnotation()) {
                if (this.hasIdentifier()) {
                    logger.logConfigMessage("metadata_warning_override_named_annotation_with_xml", existing.getAnnotation(), this.getIdentifier(), existing.getLocation(), this.getLocation());
                } else {
                    logger.logConfigMessage("metadata_warning_override_annotation_with_xml", existing.getAnnotation(), existing.getLocation(), this.getLocation());
                }
                return true;
            }
            if (this.loadedFromAnnotation() && existing.loadedFromXML()) {
                if (this.hasIdentifier()) {
                    logger.logConfigMessage("metadata_warning_override_named_annotation_with_xml", this.m_annotation, this.getIdentifier(), this.getLocation(), existing.getLocation());
                } else {
                    logger.logConfigMessage("metadata_warning_override_annotation_with_xml", this.m_annotation, this.getLocation(), existing.getLocation());
                }
            } else {
                if (this.loadedFromEclipseLinkXML() && !existing.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        logger.logConfigMessage("metadata_warning_override_named_xml_with_eclipselink_xml", existing.getXMLElement(), this.getIdentifier(), existing.getLocation(), this.getLocation());
                    } else {
                        logger.logConfigMessage("metadata_warning_override_xml_with_eclipselink_xml", existing.getXMLElement(), existing.getLocation(), this.getLocation());
                    }
                    return true;
                }
                if (!this.loadedFromEclipseLinkXML() && existing.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        logger.logConfigMessage("metadata_warning_override_named_xml_with_eclipselink_xml", existing.getXMLElement(), this.getIdentifier(), this.getLocation(), existing.getLocation());
                    } else {
                        logger.logConfigMessage("metadata_warning_override_xml_with_eclipselink_xml", existing.getXMLElement(), this.getLocation(), existing.getLocation());
                    }
                } else {
                    if (this.loadedFromAnnotation()) {
                        if (this.hasIdentifier()) {
                            throw ValidationException.conflictingNamedAnnotations((String)this.getIdentifier(), (Object)this.m_annotation, (Object)this.getLocation(), (Object)existing.getAnnotation(), (Object)existing.getLocation());
                        }
                        throw ValidationException.conflictingAnnotations((Object)this.m_annotation, (Object)this.getLocation(), (Object)existing.getAnnotation(), (Object)existing.getLocation());
                    }
                    if (existing.getLocation().equals(this.getLocation()) && existing.getEntityMappings().loadedForCanonicalModel()) {
                        return true;
                    }
                    if (this.hasIdentifier()) {
                        throw ValidationException.conflictingNamedXMLElements((String)this.getIdentifier(), (String)this.m_xmlElement, (Object)this.getLocation(), (Object)existing.getLocation());
                    }
                    throw ValidationException.conflictingXMLElements((String)this.m_xmlElement, (Object)this.getAccessibleObject(), (Object)this.getLocation(), (Object)existing.getLocation());
                }
            }
        }
        return false;
    }

    protected boolean valuesMatch(List<Object> list1, List<Object> list2) {
        if (list1.size() == list2.size()) {
            for (Object obj1 : list1) {
                if (list2.contains(obj1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean valuesMatch(Object value1, Object value2) {
        if (value1 == null && value2 != null || value2 == null && value1 != null) {
            return false;
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1.equals(value2);
    }

    private static Map<String, Class<?>> getPrimitiveClassesMap() {
        HashMap mappings = new HashMap(28);
        mappings.put("", Void.TYPE);
        mappings.put("void", Void.TYPE);
        mappings.put("Boolean", Boolean.class);
        mappings.put("Byte", Byte.class);
        mappings.put("Character", Character.class);
        mappings.put("Double", Double.class);
        mappings.put("Float", Float.class);
        mappings.put("Integer", Integer.class);
        mappings.put("Long", Long.class);
        mappings.put("Number", Number.class);
        mappings.put("Short", Short.class);
        mappings.put("String", String.class);
        mappings.put("boolean", Boolean.TYPE);
        mappings.put("byte", Byte.TYPE);
        mappings.put("char", Character.TYPE);
        mappings.put("double", Double.TYPE);
        mappings.put("float", Float.TYPE);
        mappings.put("int", Integer.TYPE);
        mappings.put("long", Long.TYPE);
        mappings.put("short", Short.TYPE);
        mappings.put("byte[]", byte[].class);
        mappings.put("char[]", char[].class);
        mappings.put("boolean[]", boolean[].class);
        mappings.put("double[]", double[].class);
        mappings.put("float[]", float[].class);
        mappings.put("int[]", int[].class);
        mappings.put("long[]", long[].class);
        mappings.put("short[]", short[].class);
        return mappings;
    }

    private static Map<String, String> getBoxedTypesMap() {
        HashMap<String, String> mappings = new HashMap<String, String>(17);
        mappings.put("void", Void.class.getName());
        mappings.put("boolean", Boolean.class.getName());
        mappings.put("byte", Byte.class.getName());
        mappings.put("char", Character.class.getName());
        mappings.put("double", Double.class.getName());
        mappings.put("float", Float.class.getName());
        mappings.put("int", Integer.class.getName());
        mappings.put("long", Long.class.getName());
        mappings.put("short", Short.class.getName());
        mappings.put("byte[]", Byte[].class.getName());
        mappings.put("char[]", Character[].class.getName());
        mappings.put("boolean[]", Boolean[].class.getName());
        mappings.put("double[]", Double[].class.getName());
        mappings.put("float[]", Float[].class.getName());
        mappings.put("int[]", Integer[].class.getName());
        mappings.put("long[]", Long[].class.getName());
        mappings.put("short[]", Short[].class.getName());
        return mappings;
    }

    private static final class SimpleORMetadata
    extends ORMetadata {
        private final Object m_value;

        public SimpleORMetadata(Object value, MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings, String xmlElement) {
            super(xmlElement);
            this.setAccessibleObject(accessibleObject);
            this.setEntityMappings(entityMappings);
            this.m_value = value;
        }

        @Override
        public boolean equals(Object objectToCompare) {
            if (objectToCompare instanceof SimpleORMetadata) {
                return this.valuesMatch(this.getValue(), ((SimpleORMetadata)objectToCompare).getValue());
            }
            return false;
        }

        public int hashCode() {
            return this.m_value != null ? this.m_value.hashCode() : 0;
        }

        public Object getValue() {
            return this.m_value;
        }
    }
}

