/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.jacc;

import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyContext;

public abstract class PolicyFactory {
    public static final String FACTORY_NAME = "jakarta.security.jacc.PolicyFactory.provider";
    private static volatile PolicyFactory policyFactory;
    private PolicyFactory wrapped;

    public static synchronized PolicyFactory getPolicyFactory() {
        if (policyFactory != null) {
            return policyFactory;
        }
        String className = System.getProperty(FACTORY_NAME);
        if (className != null) {
            try {
                policyFactory = (PolicyFactory)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException pae) {
                throw new SecurityException(pae);
            }
        }
        return policyFactory;
    }

    public static synchronized void setPolicyFactory(PolicyFactory policyFactory) {
        PolicyFactory.policyFactory = policyFactory;
    }

    public PolicyFactory() {
    }

    public PolicyFactory(PolicyFactory wrapped) {
        this.wrapped = wrapped;
    }

    public PolicyFactory getWrapped() {
        return this.wrapped;
    }

    public Policy getPolicy() {
        return this.getPolicy(PolicyContext.getContextID());
    }

    public void setPolicy(Policy policy) {
        this.setPolicy(PolicyContext.getContextID(), policy);
    }

    public abstract Policy getPolicy(String var1);

    public abstract void setPolicy(String var1, Policy var2);
}

