/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.api.core.ActionException;
import org.glassfish.shoal.gms.api.core.CallBack;
import org.glassfish.shoal.gms.api.core.PlannedShutdownAction;
import org.glassfish.shoal.gms.api.core.Signal;
import org.glassfish.shoal.gms.api.core.SignalAcquireException;
import org.glassfish.shoal.gms.api.core.SignalReleaseException;
import org.glassfish.shoal.gms.logging.GMSLogDomain;

public class PlannedShutdownActionImpl
implements PlannedShutdownAction {
    private CallBack callBack;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");

    public PlannedShutdownActionImpl(CallBack callBack) {
        this.callBack = callBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal s) throws ActionException {
        boolean signalAcquired = false;
        try {
            s.acquire();
            signalAcquired = true;
            this.callBack.processNotification(s);
        }
        catch (SignalAcquireException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        finally {
            if (signalAcquired) {
                try {
                    s.release();
                }
                catch (SignalReleaseException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }
    }
}

