/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.store.backing.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.store.backing.commands.SizeResponseCommand;
import org.glassfish.shoal.ha.cache.util.CommandResponse;
import org.glassfish.shoal.ha.cache.util.ResponseMediator;

public class SizeRequestCommand<K, V>
extends Command {
    private static final Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.command.size");
    private long tokenId;
    private String targetInstanceName;
    private Future future;

    public SizeRequestCommand() {
        super((byte)51);
        super.setKey("SizeReq:" + this.tokenId);
    }

    public SizeRequestCommand(String targetInstanceName) {
        this();
        this.targetInstanceName = targetInstanceName;
    }

    @Override
    protected boolean beforeTransmit() {
        ResponseMediator respMed = this.dsc.getResponseMediator();
        CommandResponse resp = respMed.createCommandResponse();
        this.tokenId = resp.getTokenId();
        this.future = resp.getFuture();
        this.setTargetName(this.targetInstanceName);
        return this.targetInstanceName != null;
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        ros.writeUTF(this.dsc.getInstanceName());
        ros.writeUTF(this.targetInstanceName);
        ros.writeLong(this.tokenId);
    }

    private void readObject(ObjectInputStream ris) throws IOException {
        this.targetInstanceName = ris.readUTF();
        String myName = ris.readUTF();
        this.tokenId = ris.readLong();
    }

    @Override
    public void execute(String initiator) throws DataStoreException {
        int size = this.dsc.getReplicaStore().size();
        SizeResponseCommand srCmd = new SizeResponseCommand(this.targetInstanceName, this.tokenId, size);
        this.dsc.getCommandManager().execute(srCmd);
    }

    @Override
    public String toString() {
        return this.getName() + "; tokenId=" + this.tokenId;
    }

    public int getResult() {
        int result = 0;
        try {
            result = (Integer)this.future.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected boolean isArtificialKey() {
        return true;
    }
}

