/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import org.glassfish.grizzly.threadpool.ThreadPoolInfo;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

final class ProbeNotifier {
    ProbeNotifier() {
    }

    static void notifyThreadPoolStarted(ThreadPoolInfo threadPool) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onThreadPoolStartEvent(threadPool);
            }
        }
    }

    static void notifyThreadPoolStopped(ThreadPoolInfo threadPool) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onThreadPoolStopEvent(threadPool);
            }
        }
    }

    static void notifyThreadAllocated(ThreadPoolInfo threadPool, Thread thread) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onThreadAllocateEvent(threadPool, thread);
            }
        }
    }

    static void notifyThreadReleased(ThreadPoolInfo threadPool, Thread thread) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onThreadReleaseEvent(threadPool, thread);
            }
        }
    }

    static void notifyMaxNumberOfThreads(ThreadPoolInfo threadPool, int maxNumberOfThreads) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onMaxNumberOfThreadsEvent(threadPool, maxNumberOfThreads);
            }
        }
    }

    static void notifyTaskQueued(ThreadPoolInfo threadPool, Runnable task) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onTaskQueueEvent(threadPool, task);
            }
        }
    }

    static void notifyTaskDequeued(ThreadPoolInfo threadPool, Runnable task) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onTaskDequeueEvent(threadPool, task);
            }
        }
    }

    static void notifyTaskCancelled(ThreadPoolInfo threadPool, Runnable task) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onTaskCancelEvent(threadPool, task);
            }
        }
    }

    static void notifyTaskCompleted(ThreadPoolInfo threadPool, Runnable task) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onTaskCompleteEvent(threadPool, task);
            }
        }
    }

    static void notifyTaskQueueOverflow(ThreadPoolInfo threadPool) {
        ThreadPoolProbe[] probes = threadPool.getMonitoringConfig().getProbesUnsafe();
        if (probes != null) {
            for (ThreadPoolProbe probe : probes) {
                probe.onTaskQueueOverflowEvent(threadPool);
            }
        }
    }
}

