/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.dispatchtest;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DispatchTests1
extends GenericServlet {
    private static final String TEST_HEADER = "testname";
    private static final Class[] TEST_ARGS = new Class[]{ServletRequest.class, ServletResponse.class};

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        String test = req.getParameter(TEST_HEADER);
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(test, TEST_ARGS);
            method.invoke((Object)this, req, res);
        }
        catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        }
        catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        }
        catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    public void dispatchTest1(ServletRequest request, ServletResponse response) throws IOException {
        response.getWriter().println("After dispatch=" + System.currentTimeMillis());
        response.getWriter().println("ASYNC_STARTED_dispatchTest1");
        response.getWriter().println("IsAsyncSupported=" + request.isAsyncSupported());
        response.getWriter().println("IsAsyncStarted=" + request.isAsyncStarted());
        response.getWriter().println("DispatcherType=" + String.valueOf(request.getDispatcherType()));
        response.getWriter().println("REQUEST_URI=" + String.valueOf(request.getAttribute("REQUEST_URI")));
        response.getWriter().println("CONTEXT_PATH=" + String.valueOf(request.getAttribute("CONTEXT_PATH")));
        response.getWriter().println("PATH_INFO=" + String.valueOf(request.getAttribute("PATH_INFO")));
        response.getWriter().println("SERVLET_PATH=" + String.valueOf(request.getAttribute("SERVLET_PATH")));
        response.getWriter().println("QUERY_STRING=" + String.valueOf(request.getAttribute("QUERY_STRING")));
        response.getWriter().println("ASYNC_REQUEST_URI=" + String.valueOf(request.getAttribute("ASYNC_REQUEST_URI")));
        response.getWriter().println("ASYNC_CONTEXT_PATH=" + String.valueOf(request.getAttribute("ASYNC_CONTEXT_PATH")));
        response.getWriter().println("ASYNC_PATH_INFO=" + String.valueOf(request.getAttribute("ASYNC_PATH_INFO")));
        response.getWriter().println("ASYNC_SERVLET_PATH=" + String.valueOf(request.getAttribute("ASYNC_SERVLET_PATH")));
        response.getWriter().println("ASYNC_QUERY_STRING=" + String.valueOf(request.getAttribute("ASYNC_QUERY_STRING")));
        AsyncContext ac = request.startAsync();
        response.getWriter().println("Before second dispatch=" + System.currentTimeMillis());
        ac.dispatch("/DispatchTests?testname=dispatchTest");
        response.getWriter().println("second dispatch return=" + System.currentTimeMillis());
    }
}

