/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.multifiltermapping;

import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.spec.multifiltermapping.ErrorPage;
import servlet.tck.spec.multifiltermapping.TestServlet;
import servlet.tck.spec.multifiltermapping.TestServlet6;
import servlet.tck.spec.multifiltermapping.TestServlet7;
import servlet.tck.spec.multifiltermapping.Test_ErrorFilter;
import servlet.tck.spec.multifiltermapping.Test_ForwardFilter;
import servlet.tck.spec.multifiltermapping.Test_IncludeFilter;
import servlet.tck.spec.multifiltermapping.Test_RequestFilter;
import servlet.tck.spec.requestmap.TestServlet1;
import servlet.tck.spec.requestmap.TestServlet2;
import servlet.tck.spec.requestmap.TestServlet3;
import servlet.tck.spec.requestmap.TestServlet4;
import servlet.tck.spec.requestmap.TestServlet5;

public class MultiFilterMappingTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_spec_multifiltermapping_web.war")).addAsWebResource("api/jakarta_servlet/filterrequestdispatcher/dummy.html", "dummy.html")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{ErrorPage.class, Test_ErrorFilter.class, Test_ForwardFilter.class, Test_IncludeFilter.class, TestServlet1.class, TestServlet2.class, TestServlet3.class, TestServlet4.class, TestServlet5.class, Test_RequestFilter.class, TestServlet.class, TestServlet6.class, TestServlet7.class})).setWebXML(MultiFilterMappingTests.class.getResource("servlet_spec_multifiltermapping_web.xml"));
    }

    @Test
    public void requestTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|TestServlet1");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "foo/bar/index.html");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|TestServlet1");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "foo/bar");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "foo/baR/TestServlet5");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|TestServlet2");
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "TestServlet3");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|TestServlet3");
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "foo/bar/TestServlet5");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|TestServlet5");
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "test/servletbyname");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|TestServlet6");
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "dummy.html");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|Test FAILED from dummy html page");
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "index.bop");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|TestServlet4");
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "TestServlet3/racecar.bop");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_RequestFilter|TestServlet4");
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        this.invoke();
    }

    @Test
    public void forwardTest() throws Exception {
        String testName = "forwardTest";
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|TestServlet1");
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/foo/bar/index.html HTTP/1.1");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/foo/bar HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|TestServlet1");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/foo/baR/TestServlet5 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|TestServlet2");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/TestServlet3 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|TestServlet3");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/foo/bar/TestServlet5 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|TestServlet5");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/test/servletbyname HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|TestServlet6");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/dummy.html HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|Test FAILED from dummy html page");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/index.bop HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|TestServlet4");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/TestServlet3/racecar.bop HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ForwardFilter|TestServlet4");
        this.invoke();
    }

    @Test
    public void includeTest() throws Exception {
        String testName = "includeTest";
        String filterString = "Test_IncludeFilter";
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|TestServlet1");
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/foo/bar/index.html HTTP/1.1");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/foo/bar HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|TestServlet1");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/foo/baR/TestServlet5 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|TestServlet2");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/TestServlet3 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|TestServlet3");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/foo/bar/TestServlet5 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|TestServlet5");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/test/servletbyname HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|TestServlet6");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/dummy.html HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|Test FAILED from dummy html page");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/index.bop HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|TestServlet4");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=/TestServlet3/racecar.bop HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", filterString + "|TestServlet4");
        this.invoke();
    }

    @Test
    public void errorTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "test/foo/bar/xyz");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ErrorFilter|ErrorPage");
        ((Properties)TEST_PROPS.get()).setProperty("NoServletName", "true");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "404");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=forwardTest&parameter1=/test/foo/bar/xyz HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test_ErrorFilter|ErrorPage");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "404");
        this.invoke();
    }
}

