/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.sessiontrackingmode;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.SessionTrackingMode;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class TestListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        Boolean pass = true;
        StringBuilder log = new StringBuilder();
        StringBuilder modes = new StringBuilder();
        CopyOnWriteArrayList defaults = new CopyOnWriteArrayList(context.getDefaultSessionTrackingModes());
        CopyOnWriteArrayList<SessionTrackingMode> complete = new CopyOnWriteArrayList<SessionTrackingMode>();
        complete.add(SessionTrackingMode.COOKIE);
        complete.add(SessionTrackingMode.URL);
        complete.add(SessionTrackingMode.SSL);
        for (SessionTrackingMode tmp : defaults) {
            if (tmp == SessionTrackingMode.COOKIE || tmp == SessionTrackingMode.URL || tmp == SessionTrackingMode.SSL) {
                log.append("getDefaultSessionTrackingModes=").append(tmp).append(";");
                complete.remove(tmp);
                continue;
            }
            pass = false;
            log.append("Unrecognized SessionTrackingModes ").append(tmp).append(";");
        }
        for (SessionTrackingMode tmp : complete) {
            HashSet<SessionTrackingMode> test = new HashSet<SessionTrackingMode>();
            test.add(tmp);
            try {
                context.setSessionTrackingModes(test);
            }
            catch (Exception ex) {
                log.append("Unsupported SessionTrackingModes=").append(tmp).append(";");
                complete.remove(tmp);
            }
        }
        complete.remove(SessionTrackingMode.SSL);
        if (!complete.isEmpty()) {
            context.setSessionTrackingModes(new HashSet(complete));
            for (SessionTrackingMode tmp : complete) {
                modes.append(tmp).append(";");
                log.append("Setting SessionTrackingModes to= ").append(tmp).append(";");
            }
        } else {
            log.append("Only default SessionTrackingModes are supported");
            defaults.remove(SessionTrackingMode.SSL);
            context.setSessionTrackingModes(new HashSet(defaults));
            for (SessionTrackingMode tmp : defaults) {
                modes.append(tmp).append(";");
                log.append("Setting SessionTrackingModes to Defaults = ").append(tmp).append(";");
            }
        }
        context.setAttribute("LOG", (Object)log.toString());
        context.setAttribute("MODES", (Object)modes.toString());
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

