/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.httpservletrequest40;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.DispatchServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.ForwardFilter;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.ForwardServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.IncludeServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.NamedForwardServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.NamedIncludeServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.TestServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.TrailerTestServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest40.Utilities;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.util.WebUtil;

public class HttpServletRequest40Tests
extends AbstractTckTest {
    public static final String DELIMITER = "\r\n";
    public static final String ENCODING = "ISO-8859-1";
    private WebUtil.Response response = null;

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_jsh_httpservletrequest40_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{DispatchServlet.class, ForwardFilter.class, ForwardServlet.class, IncludeServlet.class, NamedForwardServlet.class, NamedIncludeServlet.class, TestServlet.class, TrailerTestServlet.class, Utilities.class})).setWebXML(HttpServletRequest40Tests.class.getResource("servlet_jsh_httpservletrequest40_web.xml"));
    }

    @Test
    public void httpServletMappingTest() throws Exception {
        this.simpleTest("httpServletMappingTest", this.getContextRoot() + "/TestServlet", "GET", "matchValue=TestServlet, pattern=/TestServlet, servletName=TestServlet, mappingMatch=EXACT");
    }

    @Test
    public void httpServletMappingTest2() throws Exception {
        this.simpleTest("httpServletMappingTest2", this.getContextRoot() + "/a.ts", "GET", "matchValue=a, pattern=*.ts, servletName=TestServlet, mappingMatch=EXTENSION");
    }

    @Test
    public void httpServletMappingTest3() throws Exception {
        this.simpleTest("httpServletMappingTest3", this.getContextRoot() + "/default", "GET", "matchValue=, pattern=/, servletName=defaultServlet, mappingMatch=DEFAULT");
    }

    @Test
    public void httpServletMappingForwardTest() throws Exception {
        this.simpleTest("httpServletMappingForwardTest", this.getContextRoot() + "/ForwardServlet", "GET", "matchValue=a, pattern=*.ts, servletName=TestServlet, mappingMatch=EXTENSION");
    }

    @Test
    public void httpServletMappingNamedForwardTest() throws Exception {
        this.simpleTest("httpServletMappingNamedForwardTest", this.getContextRoot() + "/NamedForwardServlet", "GET", "matchValue=NamedForwardServlet, pattern=/NamedForwardServlet, servletName=NamedForwardServlet, mappingMatch=EXACT");
    }

    @Test
    public void httpServletMappingNamedIncludeTest() throws Exception {
        this.simpleTest("httpServletMappingNamedIncludeTest", this.getContextRoot() + "/NamedIncludeServlet", "GET", "matchValue=NamedIncludeServlet, pattern=/NamedIncludeServlet, servletName=NamedIncludeServlet, mappingMatch=EXACT");
    }

    @Test
    public void httpServletMappingIncludeTest() throws Exception {
        this.simpleTest("httpServletMappingIncludeTest", this.getContextRoot() + "/IncludeServlet", "POST", "matchValue=IncludeServlet, pattern=/IncludeServlet, servletName=IncludeServlet, mappingMatch=EXACT");
    }

    @Test
    public void httpServletMappingFilterTest() throws Exception {
        this.simpleTest("httpServletMappingFilterTest", this.getContextRoot() + "/ForwardFilter", "GET", "matchValue=, pattern=/, servletName=defaultServlet, mappingMatch=DEFAULT");
    }

    @Test
    public void httpServletMappingDispatchTest() throws Exception {
        this.simpleTest("httpServletMappingDispatchTest", this.getContextRoot() + "/DispatchServlet", "GET", "matchValue=TestServlet, pattern=/TestServlet, servletName=TestServlet, mappingMatch=EXACT");
    }

    private void simpleTest(String testName, String request, String method, String expected) throws Exception {
        try {
            this.logger.debug("Sending request {}", (Object)request);
            this.response = WebUtil.sendRequest((String)method, (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(request), null, null);
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(testName + " failed: ", e);
        }
        this.logger.debug("response.statusToken: {}", (Object)this.response.statusToken);
        this.logger.debug("response.content: {}", (Object)this.response.content);
        if (this.response.isError()) {
            this.logger.error("Could not find {}", (Object)request);
            throw new Exception(testName + " failed.");
        }
        if (!this.response.content.contains(expected)) {
            this.logger.error("Expected: {} but found {}", (Object)expected, (Object)this.response.content);
            throw new Exception(testName + " failed.");
        }
    }

    @Test
    public void TrailerTest() throws Exception {
        URL url = new URL("http://" + this._hostname + ":" + this._port + this.getContextRoot() + "/TrailerTestServlet");
        try (Socket socket = new Socket(url.getHost(), url.getPort());
             OutputStream output = socket.getOutputStream();){
            socket.setKeepAlive(true);
            String path = url.getPath();
            StringBuffer outputBuffer = new StringBuffer();
            outputBuffer.append("POST " + path + " HTTP/1.1\r\n");
            outputBuffer.append("Host: " + url.getHost() + DELIMITER);
            outputBuffer.append("Connection: close\r\n");
            outputBuffer.append("Content-Type: text/plain\r\n");
            outputBuffer.append("Transfer-Encoding: chunked\r\n");
            outputBuffer.append("Trailer: myTrailer, myTrailer2\r\n");
            outputBuffer.append(DELIMITER);
            outputBuffer.append("3\r\n");
            outputBuffer.append("ABC\r\n");
            outputBuffer.append("0\r\n");
            outputBuffer.append("myTrailer:foo");
            outputBuffer.append(DELIMITER);
            outputBuffer.append("myTrailer2:bar");
            outputBuffer.append(DELIMITER);
            outputBuffer.append(DELIMITER);
            byte[] outputBytes = outputBuffer.toString().getBytes(ENCODING);
            output.write(outputBytes);
            output.flush();
            InputStream input = socket.getInputStream();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            int read = 0;
            while ((read = input.read()) >= 0) {
                bytes.write(read);
            }
            String response = bytes.toString();
            this.logger.debug(response);
            if (response.indexOf("isTrailerFieldsReady: true") < 0) {
                this.logger.error("isTrailerFieldsReady should be true");
                throw new Exception("TrailerTest failed.");
            }
            if (!response.toLowerCase().contains("mytrailer=foo")) {
                this.logger.error("failed to get trailer field: mytrailer=foo");
                throw new Exception("TrailerTest failed.");
            }
            if (!response.toLowerCase().contains("mytrailer2=bar")) {
                this.logger.error("failed to get trailer field: mytrailer=foo");
                throw new Exception("TrailerTest failed.");
            }
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception("TrailerTest failed: ", e);
        }
    }

    @Test
    public void TrailerTest2() throws Exception {
        this.simpleTest("TrailerTest2", this.getContextRoot() + "/TrailerTestServlet", "POST", "isTrailerFieldsReady: true");
        this.simpleTest("TrailerTest2", this.getContextRoot() + "/TrailerTestServlet", "POST", "Trailer: {}");
    }
}

