/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.security.clientcert;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;

public class ServletSecTestServlet
extends HttpServlet {
    private boolean fail = false;
    private String FAILSTRING = "FAILED";
    private String PASSSTRING = "PASSED";

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("in service");
        PrintWriter out = response.getWriter();
        out.println("getRemoteUser(): " + request.getRemoteUser() + "<BR>");
        out.println("isUserInRole(\"ADM\"): !" + request.isUserInRole("ADM") + "!<BR>");
        String testName = "clientCertTest";
        String cipherSuiteAttrib = "jakarta.servlet.request.cipher_suite";
        String keySizeAttrib = "jakarta.servlet.request.key_size";
        String certificateAttrib = "jakarta.servlet.request.X509Certificate";
        String cipherSuite = null;
        Integer keySize = new Integer(0);
        X509Certificate[] certificates = null;
        try {
            this.fail = false;
            if (request.getUserPrincipal() != null) {
                String userPrincipalName = request.getUserPrincipal().getName();
                out.println("Caller principal Name = " + userPrincipalName);
                if (userPrincipalName.equals("")) {
                    this.fail = true;
                }
            } else {
                out.println("Caller principal = null");
                this.fail = true;
            }
            cipherSuite = (String)request.getAttribute(cipherSuiteAttrib);
            if (cipherSuite == null) {
                out.println(testName + ": " + this.FAILSTRING + " - cipher-suite attribute not set");
                this.fail = true;
            } else {
                out.println(testName + ": cipher-suite : " + cipherSuite);
            }
            keySize = (Integer)request.getAttribute(keySizeAttrib);
            if (keySize == null) {
                out.println(testName + ": " + this.FAILSTRING + " - key-size attribute not set");
                this.fail = true;
            } else {
                out.println(testName + ": key-size : " + keySize.toString());
            }
            certificates = (X509Certificate[])request.getAttribute(certificateAttrib);
            if (certificates != null) {
                for (int i = 0; i < certificates.length; ++i) {
                    X509Certificate x509Certificate = certificates[i];
                    out.println(testName + ": certificate [" + i + "]=" + x509Certificate.toString());
                }
            } else {
                out.println(testName + ": " + this.FAILSTRING + " - No SSL certificate found");
                this.fail = true;
            }
            String authType = request.getAuthType();
            if (!authType.equals("CLIENT_CERT")) {
                out.println(testName + ":" + this.FAILSTRING + " - Server returns wrong authentication type : " + authType + " : expected authentication type is CLIENT_CERT");
                this.fail = true;
            }
            if (!this.fail) {
                out.println(testName + ": " + this.PASSSTRING);
            }
        }
        catch (Exception e) {
            out.println(testName + ": " + this.FAILSTRING + " - Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

