/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.ExtensionImpl;
import com.sun.ts.tests.websocket.common.impl.ExtensionParameterImpl;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.ExtensionsServerEndpointConfig;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.ServerEndpointConfigConfigurator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.SubprotocolsServerEndpointConfig;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.WSAnnotatedConfiguratorServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.WSAnnotatedSubprotocolsServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.WSProgramaticConfiguratorServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.WSProgramaticExtensionsServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.WSProgramaticSubprotocolsServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.WSCClientIT;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 6621336154397058231L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_server_serverendpointconfig_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSClientIT.class, com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.builder.WSClientIT.class, WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig"});
        archive.addPackages(false, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{ExtensionImpl.class, ExtensionParameterImpl.class});
        archive.addClasses(new Class[]{IOUtil.class, StringUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_server_serverendpointconfig_web");
    }

    @Test
    public void getConfiguratorTest() throws Exception {
        String[] endpoints = new String[]{"programatic/subprotocols", "annotated/configurator", "programatic/configurator"};
        String[] responses = new String[]{SubprotocolsServerEndpointConfig.class.getName(), ServerEndpointConfigConfigurator.class.getName(), ServerEndpointConfigConfigurator.class.getName()};
        for (int i = 0; i != endpoints.length; ++i) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[i]}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "configurator");
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, responses[i]);
            this.invoke();
        }
    }

    @Test
    public void getEndpointClassTest() throws Exception {
        String[] endpoints = new String[]{"programatic/subprotocols", "annotated/subprotocols", "annotated/configurator", "programatic/configurator", "programatic/extensions"};
        String[] responses = new String[]{WSProgramaticSubprotocolsServer.class.getName(), WSAnnotatedSubprotocolsServer.class.getName(), WSAnnotatedConfiguratorServer.class.getName(), WSProgramaticConfiguratorServer.class.getName(), WSProgramaticExtensionsServer.class.getName()};
        for (int i = 0; i != endpoints.length; ++i) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[i]}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "endpoint");
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, responses[i]);
            this.invoke();
        }
    }

    @Test
    public void getExtensionsTest() throws Exception {
        String[] endpoints = new String[]{"programatic/subprotocols", "annotated/subprotocols", "annotated/configurator", "programatic/configurator", "programatic/extensions"};
        String[] responses = new String[]{"[]", "[]", "[]", "[]", ExtensionsServerEndpointConfig.EXT_NAMES[0] + "|" + ExtensionsServerEndpointConfig.EXT_NAMES[1]};
        for (int i = 0; i != endpoints.length; ++i) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[i]}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "extensions");
            this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, responses[i]);
            this.invoke();
        }
    }

    @Test
    public void getPathTest() throws Exception {
        String[] sequence;
        for (String endpoint : sequence = new String[]{"programatic/subprotocols", "annotated/subprotocols", "annotated/configurator", "programatic/configurator", "programatic/extensions"}) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoint}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "path");
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, endpoint);
            this.invoke();
        }
    }

    @Test
    public void getSubprotocolsTest() throws Exception {
        String[] endpoints;
        for (String endpoint : endpoints = new String[]{"programatic/subprotocols", "annotated/subprotocols"}) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoint}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "subprotocols");
            this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "abc");
            this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "def");
            this.invoke();
        }
    }

    @Test
    public void getEmptySubprotocolsTest() throws Exception {
        String[] endpoints;
        for (String endpoint : endpoints = new String[]{"annotated/configurator", "programatic/configurator", "programatic/extensions"}) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoint}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "subprotocols");
            this.invoke(false);
            String response = this.getResponseAsString();
            WSClientIT.assertEqualsInt((int)0, (int)response.replace("[", "").replace("]", "").trim().length(), (Object[])new Object[]{"Unexpected subprotocol list received", response});
            this.cleanup();
        }
    }

    @Test
    public void getUserPropertiesTest() throws Exception {
        String[] endpoints;
        for (String endpoint : endpoints = new String[]{"programatic/userproperties", "programatic/userproperties"}) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoint}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "userproperties");
            this.invoke(false);
            String response = this.getResponseAsString();
            WSClientIT.assertEquals((Object)"PASS", (Object)response, (Object[])new Object[]{"Unexpected result received", response});
            this.cleanup();
        }
    }
}

