/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.builder;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.ExtensionImpl;
import com.sun.ts.tests.websocket.common.impl.ExtensionParameterImpl;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.ServerEndpointConfigConfigurator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.builder.AppConfig;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.WSCClientIT;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 1217261514689339373L;
    static String[] endpoints = new String[]{"builder/configurator", "builder/decoders", "builder/encoders", "builder/extensions", "builder/subprotocols"};

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_server_serverendpointconfig_builder_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.builder"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{ExtensionImpl.class, ExtensionParameterImpl.class});
        archive.addClasses(new Class[]{IOUtil.class, StringUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_server_serverendpointconfig_builder_web");
    }

    @Test
    public void getConfiguratorTest() throws Exception {
        String name = AppConfig.CONFIG.getClass().getName();
        String[] responses = new String[]{ServerEndpointConfigConfigurator.class.getName(), name, name, name, name};
        for (int i = 0; i != endpoints.length; ++i) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[i]}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "configurator");
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, responses[i]);
            this.invoke();
        }
    }

    @Test
    public void getExtensionsTest() throws Exception {
        String[] responses = new String[]{"[]", "[]", "[]", AppConfig.EXT_NAMES[0] + "|" + AppConfig.EXT_NAMES[1], "[]"};
        for (int i = 0; i != endpoints.length; ++i) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[i]}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "extensions");
            this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, responses[i]);
            this.invoke();
        }
    }

    @Test
    public void getPathTest() throws Exception {
        for (String endpoint : endpoints) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoint}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "path");
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, endpoint);
            this.invoke();
        }
    }

    @Test
    public void getSubprotocolsTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[endpoints.length - 1]}));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "subprotocols");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "abc");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "def");
        this.invoke();
    }

    @Test
    public void getEmptySubprotocolsTest() throws Exception {
        for (int i = 0; i != endpoints.length - 1; ++i) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[i]}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "subprotocols");
            this.invoke(false);
            String response = this.getResponseAsString();
            WSClientIT.assertEqualsInt((int)0, (int)response.replace("[", "").replace("]", "").trim().length(), (Object[])new Object[]{"Unexpected subprotocol list received", response});
            this.cleanup();
        }
    }

    @Test
    public void getEncodersTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"builder/encoders"}));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "encoders");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanBinaryEncoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanBinaryStreamEncoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanTextEncoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanTextStreamEncoder.class.getName());
        this.invoke();
    }

    @Test
    public void getDecodersTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"builder/decoders"}));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "decoders");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanBinaryDecoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanBinaryStreamDecoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanTextDecoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanTextStreamDecoder.class.getName());
        this.invoke();
    }

    @Test
    public void getDefaultEncodersTest() throws Exception {
        for (int i = 0; i != endpoints.length; ++i) {
            if (i == 2) continue;
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[i]}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "encoders");
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "{}");
            this.invoke();
        }
    }

    @Test
    public void getDefaultDecodersTest() throws Exception {
        for (int i = 0; i != endpoints.length; ++i) {
            if (i == 1) continue;
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoints[i]}));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, "decoders");
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "{}");
            this.invoke();
        }
    }
}

