/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.GetNegotiatedSubprotocolConfigurator;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WSCSubprotocolServer
extends Endpoint
implements MessageHandler.Whole<String> {
    Session session;
    ServerEndpointConfig config;

    public void onMessage(String msg) {
        List<Object> ret = null;
        boolean contains = false;
        if (msg.equals("requested")) {
            contains = StringUtil.contains(GetNegotiatedSubprotocolConfigurator.getRequested(), WSCSubprotocolServer.getRequestedSubprotocols());
            ret = contains ? WSCSubprotocolServer.getRequestedSubprotocols() : GetNegotiatedSubprotocolConfigurator.getRequested();
        } else if (msg.equals("supported")) {
            List<String> subprotocols = this.config.getSubprotocols();
            contains = StringUtil.contains(GetNegotiatedSubprotocolConfigurator.getSupported(), (List)subprotocols);
            ret = contains ? subprotocols : GetNegotiatedSubprotocolConfigurator.getSupported();
        } else if (msg.equals("resulted")) {
            ret = Collections.singletonList("{" + GetNegotiatedSubprotocolConfigurator.getResulted() + "}");
        }
        try {
            this.session.getBasicRemote().sendText(StringUtil.collectionToString(ret));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        this.config = (ServerEndpointConfig)config;
        session.addMessageHandler((MessageHandler)this);
    }

    public void onError(Session session, Throwable thr) {
        thr.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)thr);
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getRequestedSubprotocols() {
        return Arrays.asList(StringUtil.WEBSOCKET_SUBPROTOCOLS[0], StringUtil.WEBSOCKET_SUBPROTOCOLS[2], StringUtil.WEBSOCKET_SUBPROTOCOLS[4]);
    }

    public static List<String> getSupportedSubprotocols() {
        return Arrays.asList(StringUtil.WEBSOCKET_SUBPROTOCOLS[1], StringUtil.WEBSOCKET_SUBPROTOCOLS[3], StringUtil.WEBSOCKET_SUBPROTOCOLS[5], StringUtil.WEBSOCKET_SUBPROTOCOLS[4], StringUtil.WEBSOCKET_SUBPROTOCOLS[2]);
    }
}

