/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.Partition;
import org.eclipse.fx.code.editor.configuration.PartitionRule;
import org.eclipse.fx.code.editor.configuration.PartitionWhiteSpace;
import org.eclipse.fx.code.editor.configuration.Token;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;
import org.eclipse.fx.code.editor.configuration.gson.GsonElementFactory;
import org.eclipse.fx.code.editor.configuration.gson.GsonPartitionRuleImpl;
import org.eclipse.fx.code.editor.configuration.gson.GsonTokenImpl;

public final class GsonPartitionImpl
implements GsonBase,
Partition {
    private final String name;
    private final List<PartitionRule> ruleList;
    private final List<Token> tokenList;
    private final PartitionWhiteSpace whitespace;

    public GsonPartitionImpl(JsonObject jsonObject) {
        this.name = jsonObject.has("name") ? jsonObject.get("name").getAsString() : null;
        this.ruleList = jsonObject.has("ruleList") ? Collections.unmodifiableList(StreamSupport.stream(jsonObject.getAsJsonArray("ruleList").spliterator(), false).map(e -> GsonElementFactory.createPartitionRule(e.getAsJsonObject())).collect(Collectors.toList())) : Collections.emptyList();
        this.tokenList = jsonObject.has("tokenList") ? Collections.unmodifiableList(StreamSupport.stream(jsonObject.getAsJsonArray("tokenList").spliterator(), false).map(e -> GsonElementFactory.createToken(e.getAsJsonObject())).collect(Collectors.toList())) : Collections.emptyList();
        this.whitespace = jsonObject.has("whitespace") ? GsonElementFactory.createPartitionWhiteSpace(jsonObject.getAsJsonObject("whitespace")) : null;
    }

    public GsonPartitionImpl(String name, List<PartitionRule> ruleList, List<Token> tokenList, PartitionWhiteSpace whitespace) {
        this.name = name;
        this.ruleList = ruleList;
        this.tokenList = tokenList;
        this.whitespace = whitespace;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "Partition");
        o.addProperty("name", this.getName());
        o.add("ruleList", (JsonElement)GsonBase.toDomainJsonArray(this.getRuleList()));
        o.add("tokenList", (JsonElement)GsonBase.toDomainJsonArray(this.getTokenList()));
        o.add("whitespace", this.getWhitespace() == null ? null : ((GsonBase)((Object)this.getWhitespace())).toJSONObject());
        return o;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " { name : " + this.name + ", ruleList : " + String.valueOf(this.ruleList.stream().map(e -> e.getClass().getSimpleName() + "@" + Integer.toHexString(e.hashCode())).collect(Collectors.toList())) + ", tokenList : " + String.valueOf(this.tokenList.stream().map(e -> e.getClass().getSimpleName() + "@" + Integer.toHexString(e.hashCode())).collect(Collectors.toList())) + ", whitespace : " + (this.whitespace == null ? null : this.whitespace.getClass().getSimpleName() + "@" + Integer.toHexString(this.whitespace.hashCode())) + " }";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<PartitionRule> getRuleList() {
        return this.ruleList;
    }

    @Override
    public List<Token> getTokenList() {
        return this.tokenList;
    }

    @Override
    public PartitionWhiteSpace getWhitespace() {
        return this.whitespace;
    }

    public static class Builder
    implements Partition.Builder {
        private final EditorGModel instance;
        private String name;
        private final List<PartitionRule> ruleList = new ArrayList<PartitionRule>();
        private final List<Token> tokenList = new ArrayList<Token>();
        private PartitionWhiteSpace whitespace;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder ruleList(List<PartitionRule> ruleList) {
            this.ruleList.addAll(ruleList);
            return this;
        }

        @Override
        public Builder appendRuleList(PartitionRule ruleList) {
            this.ruleList.add(ruleList);
            return this;
        }

        @Override
        public Builder ruleList(Function<EditorGModel, List<PartitionRule>> provider) {
            this.ruleList((List)provider.apply(this.instance));
            return this;
        }

        @Override
        public Builder appendRuleList(Function<PartitionRule.Builder, PartitionRule> provider) {
            this.appendRuleList(provider.apply(new GsonPartitionRuleImpl.Builder(this.instance)));
            return this;
        }

        @Override
        public Builder tokenList(List<Token> tokenList) {
            this.tokenList.addAll(tokenList);
            return this;
        }

        @Override
        public Builder appendTokenList(Token tokenList) {
            this.tokenList.add(tokenList);
            return this;
        }

        @Override
        public Builder tokenList(Function<EditorGModel, List<Token>> provider) {
            this.tokenList((List)provider.apply(this.instance));
            return this;
        }

        @Override
        public Builder appendTokenList(Function<Token.Builder, Token> provider) {
            this.appendTokenList(provider.apply(new GsonTokenImpl.Builder(this.instance)));
            return this;
        }

        @Override
        public Builder whitespace(PartitionWhiteSpace whitespace) {
            this.whitespace = whitespace;
            return this;
        }

        @Override
        public Partition build() {
            return new GsonPartitionImpl(this.name, this.ruleList, this.tokenList, this.whitespace);
        }
    }
}

