/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.CommitCompareItem;
import org.eclipse.egerrit.internal.ui.compare.CommitMsgCompareItem;
import org.eclipse.egerrit.internal.ui.compare.PatchSetCompareItem;

public class CompareItemFactory {
    private static final String COMMIT_MSG = "/COMMIT_MSG";
    private GerritClient gerrit;
    private PatchSetCompareItem newCompareItem = new PatchSetCompareItem();

    public CompareItemFactory(GerritClient gerrit) {
        this.gerrit = gerrit;
    }

    public PatchSetCompareItem createCompareItemFromRevision(String filename, String change_id, FileInfo fileInfo, IProgressMonitor monitor) {
        if (fileInfo == null || fileInfo.getRevision() == null) {
            throw new IllegalArgumentException();
        }
        if (COMMIT_MSG.equals(fileInfo.getPath())) {
            this.newCompareItem = new CommitMsgCompareItem();
        }
        this.newCompareItem.setGerritConnection(this.gerrit);
        this.newCompareItem.setFile(fileInfo);
        return this.newCompareItem;
    }

    public CommitCompareItem createCompareItemFromCommit(RevisionInfo revision, FileInfo file, String fileName, int baseRevisionNumber, IProgressMonitor progressMonitor) {
        return new CommitCompareItem(this.gerrit, revision, file, fileName, baseRevisionNumber);
    }

    public CommitCompareItem createCompareItemFromBase(RevisionInfo revision, FileInfo file, String fileName, IProgressMonitor progressMonitor) {
        return new CommitCompareItem(this.gerrit, revision, file, fileName, 0);
    }
}

