/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.tabs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egerrit.internal.ui.tabs.HyperLinkPresenter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.HyperlinkManager;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension2;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.MouseEvent;

class EGerritHyperlinkManager
extends HyperlinkManager {
    private ITextViewer fTextViewer;
    private boolean fActive;
    private int fHyperlinkStateMask;
    private int fActiveHyperlinkStateMask;
    private IHyperlink[] fActiveHyperlinks;
    private IHyperlinkDetector[] fHyperlinkDetectors;
    private IHyperlinkPresenter fHyperlinkPresenter;
    private final HyperlinkManager.DETECTION_STRATEGY fDetectionStrategy;

    EGerritHyperlinkManager(HyperlinkManager.DETECTION_STRATEGY detectionStrategy) {
        super(detectionStrategy);
        Assert.isNotNull((Object)detectionStrategy);
        this.fDetectionStrategy = detectionStrategy;
    }

    public void install(ITextViewer textViewer, IHyperlinkPresenter hyperlinkPresenter, IHyperlinkDetector[] hyperlinkDetectors, int eventStateMask) {
        super.install(textViewer, hyperlinkPresenter, hyperlinkDetectors, eventStateMask);
        Assert.isNotNull((Object)textViewer);
        Assert.isNotNull((Object)hyperlinkPresenter);
        this.fTextViewer = textViewer;
        if (this.fTextViewer.getDocument() == null) {
            Document document = new Document(this.fTextViewer.getTextWidget().getText());
            this.fTextViewer.setDocument((IDocument)document);
        }
        this.fHyperlinkPresenter = hyperlinkPresenter;
        this.fTextViewer.addTextListener((ITextListener)this);
        this.fHyperlinkPresenter.install(this.fTextViewer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setHyperlinkDetectors(IHyperlinkDetector[] hyperlinkDetectors) {
        super.setHyperlinkDetectors(hyperlinkDetectors);
        Assert.isTrue((hyperlinkDetectors != null && hyperlinkDetectors.length > 0 ? 1 : 0) != 0);
        if (this.fHyperlinkDetectors == null) {
            this.fHyperlinkDetectors = hyperlinkDetectors;
            return;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            this.fHyperlinkDetectors = hyperlinkDetectors;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void deactivate() {
        this.fActive = false;
    }

    protected IHyperlink[] findHyperlinks() {
        int offset = this.getCurrentTextOffset();
        if (offset == -1) {
            return null;
        }
        Region region = new Region(offset, 0);
        return this.findHyperlinks((IRegion)region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHyperlink[] findHyperlinks(IRegion region) {
        ArrayList<IHyperlink> allHyperlinks = new ArrayList<IHyperlink>(this.fHyperlinkDetectors.length * 2);
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            IHyperlinkDetector[] iHyperlinkDetectorArray2 = this.fHyperlinkDetectors;
            int n = this.fHyperlinkDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                int stateMask;
                IHyperlinkDetector detector = iHyperlinkDetectorArray2[n2];
                if (detector != null && !(detector instanceof IHyperlinkDetectorExtension2 ? (stateMask = ((IHyperlinkDetectorExtension2)detector).getStateMask()) != -1 && stateMask != this.fActiveHyperlinkStateMask || stateMask == -1 && this.fActiveHyperlinkStateMask != this.fHyperlinkStateMask : this.fActiveHyperlinkStateMask != this.fHyperlinkStateMask)) {
                    IHyperlink[] hyperlinks;
                    boolean canShowMultipleHyperlinks = this.fHyperlinkPresenter.canShowMultipleHyperlinks();
                    if (this.fTextViewer.getDocument() == null) {
                        Document document = new Document(this.fTextViewer.getTextWidget().getText());
                        this.fTextViewer.setDocument((IDocument)document);
                    }
                    if ((hyperlinks = detector.detectHyperlinks(this.fTextViewer, region, canShowMultipleHyperlinks)) != null) {
                        Assert.isLegal((hyperlinks.length > 0 ? 1 : 0) != 0);
                        if (this.fDetectionStrategy == FIRST) {
                            if (hyperlinks.length == 1) {
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return hyperlinks;
                            }
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return new IHyperlink[]{hyperlinks[0]};
                        }
                        allHyperlinks.addAll(Arrays.asList(hyperlinks));
                    }
                }
                ++n2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (allHyperlinks.isEmpty()) {
                return null;
            }
            if (this.fDetectionStrategy != ALL) {
                int maxLength = this.computeLongestHyperlinkLength(allHyperlinks);
                for (IHyperlink hyperlink : new ArrayList(allHyperlinks)) {
                    if (hyperlink.getHyperlinkRegion().getLength() >= maxLength) continue;
                    allHyperlinks.remove(hyperlink);
                }
            }
            if (this.fDetectionStrategy == LONGEST_REGION_FIRST) {
                return new IHyperlink[]{(IHyperlink)allHyperlinks.get(0)};
            }
            return allHyperlinks.toArray(new IHyperlink[allHyperlinks.size()]);
        }
    }

    public void mouseDown(MouseEvent event) {
        if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension2 && this.fActiveHyperlinks != null) {
            StyledText source = (StyledText)event.getSource();
            ((HyperLinkPresenter)this.fHyperlinkPresenter).setOffset(source.getCaretOffset());
            ((IHyperlinkPresenterExtension2)this.fHyperlinkPresenter).showHyperlinks(this.fActiveHyperlinks, this.fActive);
        }
        if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension && !((IHyperlinkPresenterExtension)this.fHyperlinkPresenter).canHideHyperlinks()) {
            return;
        }
        if (!this.isLocalRegisteredStateMask(event.stateMask)) {
            if (this.fActive) {
                this.deactivate();
            }
            return;
        }
        if (event.button != 1) {
            this.deactivate();
            return;
        }
        this.fActive = true;
        this.fActiveHyperlinkStateMask = event.stateMask & SWT.MODIFIER_MASK;
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            this.deactivate();
            return;
        }
        if (text.isTextSelected()) {
            this.deactivate();
            return;
        }
        this.fActiveHyperlinks = this.findHyperlinks();
    }

    public void mouseUp(MouseEvent e) {
        int cursorOffset = ((StyledText)e.getSource()).getCaretOffset();
        if (!this.fActive) {
            this.fActiveHyperlinks = null;
            return;
        }
        if (e.button != 1) {
            this.fActiveHyperlinks = null;
        }
        this.deactivate();
        IHyperlink currentHyperlink = null;
        if (this.fActiveHyperlinks == null) {
            this.fActiveHyperlinks = this.findHyperlinks();
        }
        if (this.fActiveHyperlinks != null) {
            IHyperlink[] iHyperlinkArray = this.fActiveHyperlinks;
            int n = this.fActiveHyperlinks.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlink fActiveHyperlink = iHyperlinkArray[n2];
                IRegion region = fActiveHyperlink.getHyperlinkRegion();
                if (region.getOffset() < cursorOffset && cursorOffset < region.getOffset() + region.getLength()) {
                    currentHyperlink = fActiveHyperlink;
                    break;
                }
                ++n2;
            }
            if (currentHyperlink != null) {
                this.localShowHyperlinks(true);
            }
        }
    }

    public void mouseMove(MouseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isLocalRegisteredStateMask(int stateMask) {
        if (stateMask == this.fHyperlinkStateMask) {
            return true;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            IHyperlinkDetector[] iHyperlinkDetectorArray2 = this.fHyperlinkDetectors;
            int n = this.fHyperlinkDetectors.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                IHyperlinkDetector fHyperlinkDetector = iHyperlinkDetectorArray2[n2];
                if (fHyperlinkDetector instanceof IHyperlinkDetectorExtension2 && stateMask == ((IHyperlinkDetectorExtension2)fHyperlinkDetector).getStateMask()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++n2;
            }
        }
    }

    public void focusGained(FocusEvent e) {
        this.showAllLinks();
    }

    private void showAllLinks() {
        if (this.fActiveHyperlinks == null && this.fTextViewer != null && !this.fTextViewer.getTextWidget().getText().isEmpty()) {
            if (this.fTextViewer.getDocument() == null) {
                return;
            }
            Region region = new Region(0, ((TextViewer)this.fTextViewer).getBottomIndexEndOffset());
            this.fActiveHyperlinks = this.findHyperlinks((IRegion)region);
            if (this.fActiveHyperlinks != null && this.fActiveHyperlinks.length > 1) {
                this.localShowHyperlinks(true);
            } else {
                this.localShowHyperlinks(false);
            }
        }
    }

    private boolean localShowHyperlinks(boolean takesFocusWhenVisible) {
        if (this.fActiveHyperlinks == null || this.fActiveHyperlinks.length == 0) {
            return false;
        }
        if (this.fActiveHyperlinks.length == 1 && takesFocusWhenVisible) {
            this.fActiveHyperlinks[0].open();
        } else {
            this.fHyperlinkPresenter.showHyperlinks(this.fActiveHyperlinks);
        }
        return true;
    }

    public boolean openHyperlink() {
        this.fActiveHyperlinkStateMask = this.fHyperlinkStateMask;
        if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension && !((IHyperlinkPresenterExtension)this.fHyperlinkPresenter).canHideHyperlinks()) {
            return false;
        }
        ITextSelection sel = (ITextSelection)((TextViewer)this.fTextViewer).getSelection();
        int offset = sel.getOffset();
        if (offset == -1) {
            return false;
        }
        Region region = new Region(offset, 0);
        this.fActiveHyperlinks = this.findHyperlinks((IRegion)region);
        return this.localShowHyperlinks(true);
    }
}

