/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.ui;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.embedcdt.internal.ui.Activator;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.osgi.service.prefs.BackingStoreException;

public class ThemeColorFieldEditor
extends ColorFieldEditor {
    private String fThemeColorName;
    private ColorRegistry fColorRegistry;

    public ThemeColorFieldEditor(String name, String themeColorName, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.fThemeColorName = themeColorName;
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme theme = themeManager.getCurrentTheme();
        this.fColorRegistry = theme.getColorRegistry();
    }

    protected void doLoad() {
        if (this.getColorSelector() == null) {
            return;
        }
        RGB rgb = this.fColorRegistry.getRGB(this.fThemeColorName);
        this.getColorSelector().setColorValue(rgb);
    }

    protected void doLoadDefault() {
        if (this.getColorSelector() == null) {
            return;
        }
        RGB rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName());
        this.getColorSelector().setColorValue(rgb);
        this.setPresentsDefaultValue(false);
    }

    protected void doStore() {
        RGB rgb = this.getColorSelector().getColorValue();
        this.fColorRegistry.put(this.fThemeColorName, rgb);
        String value = String.format("%d,%d,%d", rgb.red, rgb.green, rgb.blue);
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.workbench");
        if (!value.equals(preferences.get(this.fThemeColorName, ""))) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("Color " + this.fThemeColorName + "=" + value);
            }
            preferences.put(this.fThemeColorName, value);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
        }
    }
}

